export ALFRED_ROOT=$(pwd)

# Train master policy
CUDA_VISIBLE_DEVICES=0 python MasterPolicy/models/train/train_seq2seq.py \
				--dout exp/nav_aug \
				--batch 8 \
				--lr 1e-4 \
				--resume exp/nav_aug/net_epoch_3.pth \
				--gpu \
				--save_every_epoch \
				--panoramic \
				--panoramic_concat 


# Train CleanObject subgoal policy
CUDA_VISIBLE_DEVICES=0 python Interactions/models/train/train_seq2seq.py \
				--subgoal_analysis=CleanObject \
				--dout exp/CleanObject \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \

# Train HeatObject subgoal policy
CUDA_VISIBLE_DEVICES=0 python Interactions/models/train/train_seq2seq.py \
				--subgoal_analysis=HeatObject \
				--dout exp/HeatObject \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \

# Train CoolObject subgoal policy
CUDA_VISIBLE_DEVICES=0 python Interactions/models/train/train_seq2seq.py \
				--subgoal_analysis=CoolObject \
				--dout exp/CoolObject \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \

# Train SliceObject subgoal policy
CUDA_VISIBLE_DEVICES=0 python Interactions/models/train/train_seq2seq.py \
				--subgoal_analysis=SliceObject \
				--dout exp/SliceObject \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \

# Train ToggleObject subgoal policy
CUDA_VISIBLE_DEVICES=0 python Interactions/models/train/train_seq2seq.py \
				--subgoal_analysis=ToggleObject \
				--dout exp/ToggleObject \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \

# Train PickupObject subgoal policy
CUDA_VISIBLE_DEVICES=0 python Interactions/models/train/train_seq2seq.py \
				--subgoal_analysis=PickupObject \
				--dout exp/PickupObject \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \

# Train PutObject subgoal policy
CUDA_VISIBLE_DEVICES=0 python Interactions/models/train/train_seq2seq.py \
				--subgoal_analysis=PutObject \
				--dout exp/PutObject \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \


# Train policy composition controller
CUDA_VISIBLE_DEVICES=0 python PCC/models/train/train_seq2seq.py 
				--dout exp/PCC 
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \
				--panoramic \
				--panoramic_concat 


# Train Object Encoding Module
CUDA_VISIBLE_DEVICES=0 python models/train/train_seq2seq.py \
				--dout exp/OEM \
				--batch 16 \
				--lr 1e-3 \
				--gpu \
				--save_every_epoch \
				--panoramic \
				--panoramic_concat



