export ALFRED_ROOT=$(pwd)

EPOCHS=(0_2628 1211)

for epoch in ${EPOCHS[@]}
do
	CUDA_VISIBLE_DEVICES=1 python models/eval/leaderboard.py			\
		--nav_model_path ../moca_panoramic_navonly_aug_finetune/exp/augManTest_finetune_3_nav_aug/net_epoch_${epoch}.pth  \
		--pickup_model_path ../moca_panoramic_manonly/exp/augPickupObject/net_epoch_0_2628.pth  \
		--put_model_path ../moca_panoramic_manonly/exp/augPutObject/net_epoch_1.pth  \
		--cool_model_path ../moca_panoramic_manonly/exp/augCoolObject/net_epoch_9.pth  \
		--clean_model_path ../moca_panoramic_manonly/exp/augCleanObject/net_epoch_9.pth  \
		--heat_model_path ../moca_panoramic_manonly/exp/augHeatObject/net_epoch_4_7884.pth  \
		--slice_model_path ../moca_panoramic_manonly/exp/augSliceObject/net_epoch_3_5256.pth  \
		--toggle_model_path ../moca_panoramic_manonly/exp/augToggleObject/net_epoch_1_2628.pth  \
		--object_model_path exp/obj_pred/extraFC/net_epoch_3.pth  \
		--subgoal_model_path exp/subgoal_pred/net_epoch_5.pth  \
		--gpu                                               \
		--dout leaderboard_3_woGoBack_directManReturn_loop_break_scr0.3_logs_nav1_7884_augManip								\
		--num_threads 4 \
		--logs "leaderboard_3_woGoBack_earlyManReturn_loop_break_scr0.3_logs_sep2_11_30am.txt"
done
# --model_path	"exp/moca_batch16_lr3_autoaug/net_epoch_${epoch}.pth"	\
