export ALFRED_ROOT=$(pwd)

EPOCHS=(1_7884 1_2628)

for epoch in ${EPOCHS[@]}
do
	CUDA_VISIBLE_DEVICES=1 python models/eval/leaderboard.py			\
		--nav_model_path MasterPolicy/exp/nav_aug/net_epoch_3.pth  \
		--pickup_model_path Interactions/exp/PickupObject/net_epoch_48.pth  \
		--put_model_path Interactions/exp/PutObject/net_epoch_49.pth  \
		--heat_model_path Interactions/exp/HeatObject/net_epoch_30.pth  \
		--cool_model_path Interactions/exp/CoolObject/net_epoch_49.pth  \
		--clean_model_path Interactions/exp/CleanObject/net_epoch_49.pth  \
		--toggle_model_path Interactions/exp/ToggleObject/net_epoch_34.pth  \
		--slice_model_path Interactions/exp/SliceObject/net_epoch_36.pth  \
		--object_model_path OEM/exp/obj_pred/extraFC/net_epoch_3.pth  \
		--subgoal_model_path PCC/exp/subgoal_pred/net_epoch_5.pth  \
		--gpu                                               \
		--dout leaderboard_$epoch								\
		--num_threads 1 \
		--logs "leaderboard.txt"
done