import pandas as pd

# Last Letter
last_letter_skic_instruction = '''
Skill <Words_to_list>: Put the asked words to a list. For example, put the words in 'apple' to D=['apple'], put the words in 'apple, banana' to D=['apple','banana'] 

Skill <Last_letter>: Get the last letter of one word. For example, the last letter of 'apple' is 'e', the last letter of 'banana' is 'a'


Compose these skills to do the task.
Example #1: Take the last letters of the words in 'apple, banana' and concatenate them.
Answer:
<C>
1. Using the Skill <Words_to_list>, put the asked words, 'apple, banana', to a list. D=['apple','banana']
2. Get the last letter of each word in the list D=['apple','banana'] to a new list R=[]:
    i. Using the Skill <Last_letter>, the last letter of D[0]='apple' is 'e'. R=[e]
    ii. Using the Skill <Last_letter>, the last letter of D[1]='banana' is 'a'. R=[e,a]
3. The answer is R=[e,a] 
</C>
[e,a]
<EOD>

Example #2: Take the last letters of the words in 'deep, learning' and concatenate them.
Answer:
<C>
1. Using the Skill <Words_to_list>, put the asked words, 'deep, learning', to a list. D=['deep','learning']
2. Get the last letter of each word in the list D=['deep','learning'] to a new list R=[]:
    i. Using the Skill <Last_letter>, the last letter of D[0]='deep' is 'p'. R=[p]
    ii. Using the Skill <Last_letter>, the last letter of D[1]='learning' is 'g'. R=[p,g]
3. The answer is R=[p,g]
</C>
[p,g]
<EOD>

Following the above examples, use your skills to answer:
'''
prompts = pd.read_csv('last_letter_all.csv')
# An example
prompt= prompts['prompt'][0]
answer = prompt['answer'][0]
input_last_letter = last_letter_skic_instruction + '\n' + prompt + '\nAnswer:'


# Add
add_skic_instruction = '''
Skill <Extract Digits>: Extract the digits in a number to a list.  Extract digits in 123 to D=[1,2,3]. Extract digits in 7654 to D=[7,6,5,4].

Skill <Add single-digits>: Add two single-digit numbers. 
0+0=0 0+1=1 0+2=2 0+3=3 0+4=4 0+5=5 0+6=6 0+7=7 0+8=8 0+9=9
1+0=1 1+1=2 1+2=3 1+3=4 1+4=5 1+5=6 1+6=7 1+7=8 1+8=9 1+9=10
2+0=2 2+1=3 2+2=4 2+3=5 2+4=6 2+5=7 2+6=8 2+7=9 2+8=10 2+9=11
3+0=3 3+1=4 3+2=5 3+3=6 3+4=7 3+5=8 3+6=9 3+7=10 3+8=11 3+9=12
4+0=4 4+1=5 4+2=6 4+3=7 4+4=8 4+5=9 4+6=10 4+7=11 4+8=12 4+9=13
5+0=5 5+1=6 5+2=7 5+3=8 5+4=9 5+5=10 5+6=11 5+7=12 5+8=13 5+9=14
6+0=6 6+1=7 6+2=8 6+3=9 6+4=10 6+5=11 6+6=12 6+7=13 6+8=14 6+9=15
7+0=7 7+1=8 7+2=9 7+3=10 7+4=11 7+5=12 7+6=13 7+7=14 7+8=15 7+9=16
8+0=8 8+1=9 8+2=10 8+3=11 8+4=12 8+5=13 8+6=14 8+7=15 8+8=16 8+9=17
9+0=9 9+1=10 9+2=11 9+3=12 9+4=13 9+5=14 9+6=15 9+7=16 9+8=17 9+9=18

Skill <Sub 10>: 10-10=0 11-10=1 12-10=2 13-10=3 14-10=4 15-10=5 16-10=6 17-10=7 18-10=8 19-10=9

Skill <Compare 10>: 0<10 1<10 2<10 3<10 4<10 5<10 6<10 7<10 8<10 9<10 10=10 11>10 12>10 13>10 14>10 15>10 16>10 17>10 18>10 19>10


Compose these skills to add two numbers.
Example #1: Calculate 16+74:
Answer:
<C>
1. Using Skill <Extract Digits>, extract the digits in 16 to DM=[1,6]. len(DM)=2. Extract the digits in 74 to DN=[7,4]. len(DN)=2.
2. len(DM)=2=len(DN)=2. Align the two lists by adding len(DM)-len(DN)=0 zeros: DM=[1,6], DN=[7,4].
3. Using Skill <Add single-digits>, add every number in DM=[1,6] to the corresponding number in DN =[7,4] to form a list, DS=[1+7,6+4]=[8,10].
4. Append a 0 to the beginning of DS: DS=[0,8,10]. Construct a list R=[0,0,0] with l=len(DS)=3 zeros. 
5. DS=[0,8,10] (DS[0]=0, DS[1]=8,DS[2]=10), starting from DS[2] to DS[1]  (DS[2]=10, DS[1]=8):
    i. DS[2]=10, R[2]=0, R[2]=R[2]+DS[2]=0+10=10. Based on Skill <Compare 10>, 10=10, R[2]=10=10, so R[1]=1 and R[2]=10-10=0 by Skill <Sub 10>. R=[R[0],R[1],R[2]]=[0,1,0].
    ii. DS[1]=8, R[1]=0, R[1]=R[1]+DS[1]=1+8=9. Based on Skill <Compare 10>, 9<10, R[1]=9<10, so R[0]=0 and R[1]=9. R=[R[0],R[1],R[2]]=[0,9,0].
6. R=[0,9,0]. The answer is 90.
</C>
90
<EOD>

Example #2: Calculate 86+964:
Answer:
<C>
1. Using Skill <Extract Digits>, extract the digits in 86 to DM=[8,6]. len(DM)=2. Extract the digits in 964 to DN=[9,6,4]. len(DN)=3.
2. len(DM)=2<len(DN)=3. Align the two lists by adding len(DN)-len(DM)=1 zeros to the short list (DM): DM=[0,8,6].
3. Using Skill <Add single-digits>, add every number in DM=[0,8,6] to the corresponding number in DN =[9,6,4] to form a list, DS=[0+9,8+6,6+4]=[9,14,10].
4. Append a 0 to the beginning of DS: DS=[0,9,14,10].  Construct a list R=[0,0,0,0] with l=len(DS)=4 zeros. 
5.  DS=[0,9,14,10] (DS[0]=0, DS[1]=9, DS[2]=14, DS[3]=10), starting from DS[3] to DS[1] (DS[3]=10, DS[2]=14, DS[1]=9):
    i. DS[3]=10, R[3]=0, R[3]=R[3]+DS[3]=0+10=10. Based on Skill <Compare 10>, 10=10, R[3]=10=10, so R[2]=1 and R[3]=10-10=0 by Skill <Sub 10>. R=[R[0],R[1],R[2],R[3]]=[0,0,1,0].
    ii. DS[2]=14, R[2]=1, R[2]=R[2]+DS[2]=1+14=15. Based on Skill <Compare 10>, 15>10, R[2]=15>10, so R[1]=1 and R[2]=15-10=5 by Skill <Sub 10>. R=[R[0],R[1],R[2],R[3]]=[0,1,5,0].
    iii. DS[1]=9, R[1]=1, R[1]=R[1]+DS[1]=1+9=10. Based on Skill <Compare 10>, 10=10, R[1]=10=10, so R[0]=1 and R[1]=10-10=0 by Skill <Sub 10>. R=[R[0],R[1],R[2],R[3]]=[1,0,5,0].
6. R=[1,0,5,0]. The answer is 1050.
</C>
1050
<EOD>

Following the above examples, use your skills to answer:
'''
prompts = pd.read_csv('simple_add_all.csv')
# An example
prompt= prompts['prompt'][0]
answer = prompt['answer'][0]
input_add = add_skic_instruction + '\n' + prompt + '\nAnswer:'


# Mul
mul_skic_instruction = '''
Skill <Extract Digits>: Extract the digits in a number to a list.  Extract digits in 123 to D=[1,2,3]. Extract digits in 7654 to D=[7,6,5,4].

Skill <Mul single-digits>: Multiple two single-digit numbers:
0*1=0 0*2=0 0*3=0 0*4=0 0*5=0 0*6=0 0*7=0 0*8=0 0*9=0
1*1=1 1*2=2 1*3=3 1*4=4 1*5=5 1*6=6 1*7=7 1*8=8 1*9=9
2*1=2 2*2=4 2*3=6 2*4=8 2*5=10 2*6=12 2*7=14 2*8=16 2*9=18
3*1=3 3*2=6 3*3=9 3*4=12 3*5=15 3*6=18 3*7=21 3*8=24 3*9=27
4*1=4 4*2=8 4*3=12 4*4=16 4*5=20 4*6=24 4*7=28 4*8=32 4*9=36
5*1=5 5*2=10 5*3=15 5*4=20 5*5=25 5*6=30 5*7=35 5*8=40 5*9=45
6*1=6 6*2=12 6*3=18 6*4=24 6*5=30 6*6=36 6*7=42 6*8=48 6*9=54
7*1=7 7*2=14 7*3=21 7*4=28 7*5=35 7*6=42 7*7=49 7*8=56 7*9=63
8*1=8 8*2=16 8*3=24 8*4=32 8*5=40 8*6=48 8*7=56 8*8=64 8*9=72
9*1=9 9*2=18 9*3=27 9*4=36 9*5=45 9*6=54 9*7=63 9*8=72 9*9=81

Skill <Add multiple numbers>: Add multiple numbers such as m+n+p: 1. Add the first two numbers m+n and get the result r1=m+n. 2. Add the third number p to r1 and get the result r2=r1+p. 
Example #1: Calculate 128+64+79
1. Add the first two numbers 128+64 and use Skill <Add> to get the result r1=128+64=192.
2. Add the third number 79 to r1 and use Skill <Add> to get the result r2=192+79=271.
So 128+64+79=271 

Example #2: Calculate 126+90+173+97
1. Add the first two numbers 126+90 and use Skill <Add> to get the result r1=126+90=216.
2. Add the third number 173 to r1 and use Skill <Add> to get the result r2=216+173=389.
3. Add the fourth number 97 to r2 and use Skill <Add> to get the result r3=389+97=486.
So 126+90+173+97=486 


Compose these skills to multiply two numbers.
Example #1: Calculate 28*67:
Answer:
<C>
1. Using Skill <Extract Digits>, extract the digits in 28 to DM=[2,8]. len(DM)=2. Extract the digits in 67 to DN=[6,7]. len(DN)=2.
2. Add 0,len(DM)-1=1 zeros to the end of every number in DM=[2,8] according to the position of the number in DM: DMO=[2*10,8*1]=[20,8].
3. Add 0,len(DN)-1=1 zeros to the end of every number in DN=[6,7] according to the position of the number in DN: DNO=[6*10,7*1]=[60,7].
4. Using Skill <Mul single-digits>, multiple every number in DMO=[20,8] with every number in DNO=[60,7] and get R=[20*60,20*7,8*60,8*7]=[1200,140,480,56].
5. Using Skill <Add multiple numbers>, add all the numbers in R=[1200,140,480,56], 1200+140+480+56:
    i. Add the first two numbers using Skill <Add>: r1=1200+140=1340.
    ii. Add the third number 480 to r1=1340 using Skill <Add>: r2=1340+480=1820.
    iii. Add the fourth number 56 to r2=1820 using Skill <Add>: r3=1820+56=1876.
6. So the answer is 1876
</C>
1876
<EOD>

Example #2: Calculate 184*67:
Answer:
<C>
1. Using Skill <Extract Digits>, extract the digits in 184 to DM=[1,8,4]. len(DM)=3. Extract the digits in 67 to DN=[6,7]. len(DN)=2.
2. Add 0,1,len(DM)-1=2 zeros to the end of every number in DM=[1,8,4] according to the position of the number in DM: DMO=[1*100,8*10,4*1]=[100,80,4].
3. Add 0,len(DN)-1=1 zeros to the end of every number in DN=[6,7] according to the position of the number in DN: DNO=[6*10,7*1]=[60,7].
4. Using Skill <Mul single-digits>, multiple every number in DMO=[100,80,4] with every number in DNO=[60,7] and get R=[100*60,100*7,80*60,80*7,4*60,4*7]=[6000,700,4800,560,240,28].
5. Using Skill <Add multiple numbers>, add all the numbers in R=[6000,700,4800,560,240,28], 6000+700+4800+560+240+28:
    i. Add the first two numbers using Skill <Add>: r1=6000+700=6700.
    ii. Add the third number 4800 to r1=6700 using Skill <Add>: r2=6700+4800=11500.
    iii. Add the fourth number 560 to r2=11500 using Skill <Add>: r3=11500+560=12060.
    iv. Add the fifth number 240 to r3=12060 using Skill <Add>: r4=12060+240=12300.
    v. Add the sixth number 28 to r4=12300 using Skill <Add>: r5=12300+28=12328.
6. So the answer is 12328
</C>
12328
<EOD>

Following the above examples, use your skills to answer:
'''
prompts = pd.read_csv('simple_mul_all.csv')
# An example
prompt= prompts['prompt'][0]
answer = prompt['answer'][0]
input_mul = mul_skic_instruction + '\n' + prompt + '\nAnswer:'



#QA
qa_skic_instruction = '''
Skill <Decompose qa>: Decompose a complex question into a set of sub-questions. 
Example #1: Decompose the question "What awards have movies produced by people born in 1910 won?" into the following sub-questions:
Q1: Who were born in the year 1910?
Q2: Which movies did [A1] produce?
Q3: Which awards were given to [A2]?
Example #2: Decompose the question "What movies have people from the country Stridery acted in?" into the following sub-questions:
Q1: Who is from the country Stridery?
Q2: Which movies did [A1] act in?

Skill <Answer simple question>: Answer simple questions about the passage.
Exempla #1: 
movie: Premercy ; directed by: Muntaril. movie: Skirtsicine ; director: Teeplemole. movie: Featsaw; directed by: Monsterscar. movie: Zalate ; director: Monsterscar. movie: Zalate ; awarded: Hallowcock. movie: Featsaw ; awarded: Zorgion. movie: Premercy ; award: Chowwurst. movie: Skirtsicine ; award: Hallowcock. award: Goatfly ; winner: Teeplemole. person: Monsterscar ; award: Glodome. person: Muntaril ; award: Goatfly. movie: Featsaw ; release year: 1973. movie: Zalate ; release year: 1964. movie: Skirtsicine ; release year: 1973. movie: Premercy ; year: 1961. Teeplemole was an actor in the movie Skirtsicine. Muntaril was an actor in the movie Skirtsicine. Monsterscar was an actor in the movie Premercy. Muntaril was an actor in the movie Featsaw. Teeplemole was an actor in the movie Zalate. Muntaril was born in the year 1910. Teeplemole was born in 1910. Monsterscar was born in 1942. Teeplemole is from the country of Piperfish. Monsterscar is from the country of Piperfish. Muntaril grew up in the nation of Clony. Muntaril produced the movie Skirtsicine with others. Monsterscar was one of the producers of the movie Featsaw. Monsterscar produced the movie Premercy with others. Monsterscar produced the movie Zalate with others. Teeplemole was one of the producers of the movie Featsaw. Teeplemole produced the movie Zalate with others. Muntaril produced the movie Premercy with others. Monsterscar wrote for the movie Premercy. Muntaril was one of the writers for the movie Zalate. Muntaril wrote for the movie Featsaw. Teeplemole wrote for the movie Featsaw. Monsterscar was one of the writers for the movie Zalate. Teeplemole was one of the writers for the movie Skirtsicine.
Q: Which awards were given to Zalate? A: movie: Zalate ; awarded: Hallowcock. ["Hallowcock”]
Q: Which movies were given the Hallowcock award? A: movie: Zalate ; awarded: Hallowcock. movie: Skirtsicine ; award: Hallowcock. ["Zalate", "Skirtsicine"]
Q: Which movies did Muntaril direct? A: movie: Premercy ; directed by: Muntaril. ["Premercy]
Q: Which movies did Muntrail produce? A: Muntaril produced the movie Premercy with others. Muntaril produced the movie Skirtsicine with others. ["Premercy", "Skirtsicine"]
Q: Which movies did Muntrail write? A: Muntaril was one of the writers for the movie Zalate. Muntaril wrote for the movie Featsaw. ["Zalate", "Featsaw"]
Q: Who are the actors in the movie Premercy? A: Monsterscar was an actor in the movie Premercy. ["Monsterscar"]
Q: When was the moive Featsaw released? A: Monsterscar was an actor in the movie Premercy. ["1973"]


Compose these basic skills to do the task.
Example #1: 
movie: Nilitude ; director: Monsterscar. movie: Dewbar ; directed by: Metatoun. movie: Warpstone; directed by: Gastrat. movie: Partnershipmaker ; director: Metatoun. movie: Dewbar ; award: Tachychronograph. movie: Partnershipmaker ; awarded: Tachychronograph. movie: Nilitude ; award: Paleodactyl. movie: Warpstone ; award: Sabonade. person: Gastrat ; award: Trifogation. award: Polyquadrase ; winner: Monsterscar. award: Trifogation ; winner: Metatoun. movie: Warpstone ; release year: 1956. movie: Dewbar ; release year: 1984. movie: Nilitude ; year: 1984. movie: Partnershipmaker ; year: 1962. Gastrat was an actor in the movie Partnershipmaker. Metatoun was an actor in the movie Partnershipmaker. Metatoun was an actor in the movie Nilitude. Gastrat acted in the movie Nilitude. Monsterscar was an actor in the movie Dewbar. Gastrat acted in the movie Warpstone. Metatoun acted in the movie Warpstone. Metatoun was born in 1939. Gastrat was born in the year 1933. Monsterscar was born in 1933. Metatoun grew up in the nation of Moulole. Gastrat grew up in the nation of Stridery. Monsterscar grew up in the nation of Moulole. Monsterscar produced the movie Nilitude with others. Monsterscar was one of the producers of the movie Warpstone. Metatoun was one of the producers of the movie Warpstone. Gastrat was one of the producers of the movie Nilitude. Metatoun produced the movie Partnershipmaker with others. Metatoun produced the movie Dewbar with others. Monsterscar was one of the producers of the movie Partnershipmaker. Gastrat produced the movie Dewbar with others. Metatoun wrote for the movie Partnershipmaker. Gastrat wrote for the movie Warpstone. Gastrat was one of the writers for the movie Dewbar. Monsterscar was one of the writers for the movie Nilitude. Metatoun wrote for the movie Warpstone.
Q:What movies have people from the country Stridery acted in?
A:
<C>
1. Using the Skill <Decompose qa>:, decompose the question "What movies have people from the country Stridery acted in?" into the following sub-questions:
    Q1: Who is from the country Stridery?
    Q2: Which movies did [A1] act in?
2. Using the Skill <Answer simple question>, answer Q1: Who is from the country Stridery?
    Gastrat grew up in the nation of Stridery. A1=["Gastrat"]
3. A1=["Gastrat"]. Using the Skill <Answer simple question>, answer Q2: Which movies did [A1] act in?
    i. A1[0]="Gastrat", answer Q2.1: Which movies did Gastrat act in? A2.1: Gastrat was an actor in the movie Partnershipmaker. Gastrat was an actor in the movie Partnershipmaker. Gastrat acted in the movie Warpstone.  ["Partnershipmaker", "Nilitude", "Warpstone"]
    ii.So A2=[A2.1]=["Partnershipmaker", "Nilitude", "Warpstone"]
4. The answer is ["Partnershipmaker", "Nilitude", "Warpstone"]
</C>
["Partnershipmaker", "Nilitude", "Warpstone"]
<EOD>

Example #2: 
movie: Premercy ; directed by: Muntaril. movie: Skirtsicine ; director: Teeplemole. movie: Featsaw; directed by: Monsterscar. movie: Zalate ; director: Monsterscar. movie: Zalate ; awarded: Hallowcock. movie: Featsaw ; awarded: Zorgion. movie: Premercy ; award: Chowwurst. movie: Skirtsicine ; award: Hallowcock. award: Goatfly ; winner: Teeplemole. person:Monsterscar ; award: Glodome. person: Muntaril ; award: Goatfly. movie: Featsaw ; release year: 1973. movie: Zalate ; release year: 1964. movie: Skirtsicine ; release year: 1973. movie: Premercy ; year: 1961. Teeplemole was an actor in the movie Skirtsicine. Muntaril was an actor in the movie Skirtsicine. Monsterscar was an actor in the movie Premercy. Muntaril was an actor in the movie Featsaw. Teeplemole was an actor in the movie Zalate. Muntaril was born in the year 1910. Teeplemole was born in 1910. Monsterscar was born in 1942. Teeplemole is from the country of Piperfish. Monsterscar is from the country of Piperfish. Muntaril is from the country of Clony. Muntaril produced the movie Skirtsicine with others. Monsterscar was one of the producers of the movie Featsaw. Monsterscar produced the movie Premercy with others. Monsterscar produced the movie Zalate with others. Teeplemole was one of the producers of the movie Featsaw. Teeplemole produced the movie Zalate with others. Muntaril produced the movie Premercy with others. Monsterscar wrote for the movie Premercy. Muntaril was one of the writers for the movie Zalate. Muntaril wrote for the movie Featsaw. Teeplemole wrote for the movie Featsaw. Monsterscar was one of the writers for the movie Zalate. Teeplemole was one of the writers for the movie Skirtsicine.
Q:What awards have movies produced by people born in 1910 won?
A:
<C>
1. Using the Skill <Decompose qa>:, decompose the question "What awards have movies produced by people born in 1910 won?" into the following sub-questions:
    Q1: Who was born in 1910?
    Q2: Which movies did [A1] produce?
    Q3: Which awards were given to [A2]?
2. Using the Skill <Answer simple question>, answer Q1: Who was born in 1910?
    Gastrat acted in the movie Warpstone. A1=["Muntaril", "Teeplemole"]
3. A1=["Muntaril", "Teeplemole"]. Using the Skill <Answer simple question>, answer Q2: Which movies did [A1] produce?
    i. A1[0]="Muntaril", answer Q2.1: Which movies did Muntaril produce? A2.1: Muntaril produced the movie Premercy with others. ["Premercy"]
    ii. A1[1]="Teeplemole", answer Q2.2: Which movies did Teeplemole produce? A2.2: Teeplemole was one of the producers of the movie Featsaw. Teeplemole produced the movie Zalate with others. ["Featsaw", "Zalate"]
    iii. So A2=A2.1+A2.2=["Premercy", "Featsaw", "Zalate"]
4. A2=["Premercy", "Featsaw", "Zalate"]. Using the Skill <Answer simple question>, answer Q3: Which awards were given to [A2]?
    i. A2[0]="Premercy", answer Q3.1: Which awards were given to Premercy? A3.1: movie: Premercy ; award: Chowwurst. ["Chowwurst"]
    ii. A2[1]="Featsaw", answer Q3.2: Which awards were given to Featsaw? A3.2: movie: Featsaw ; awarded: Zorgion. ["Zorgion"]
    iii. A2[2]="Zalate", answer Q3.3: Which awards were given to Zalate? A3.3: movie: Zalate ; awarded: Hallowcock. ["Hallowcock"]
    iv. So A3=A3.1+A3.2+A3.3=["Chowwurst", "Zorgion", "Hallowcock"]
5. The answer is ["Chowwurst", "Zorgion", "Hallowcock"]
</C>
["Chowwurst", "Zorgion", "Hallowcock"]
<EOD>

Following the above examples, use your skills to answer:
'''
prompts = pd.read_csv('cqae_iid_test_eg100.csv')
# An example
passage = prompts['passage'][0]
prompt = prompts['prompt'][0]
answer = prompts['answer'][0]
input_qa = qa_skic_instruction + '\n' + passage + '\n' + prompt + 'A:'


# DP
dp_skic_instruction = '''
Skill <list_length>: Get the number of elements in a list. 
For example, D=[1,2,3], len(D)=3. A=[1,2,3,4,5,6], len(A)=6.

Skill <find_max>: Find the max number in a list.
For example, max(2,0,-1)=2. max(-3,-2,-1)=-1. max(5,-2,0)=5. max(0,-2,4)=4. max(0,0,0)=0. max(-2,-1,0)=0.

Skill <add>: Add two numbers.
For example, 1+2=3. -2+1=-1. 0+(-3)=-3. 1+(-1)=0.

Compose these skills to do the task: Given a sequence of integers, find a subsequence with the highest sum, such that no two numbers in the subsequence are adjacent in the original sequence. 
Example #1 A=[3,2,1,5].
Answer:
<C> 
1. A=[3,2,1,5] (A[0]=3,A[1]=2,A[2]=1,A[3]=5). Using Skill <list_length>, len(A)=4. Construct a list D=[0,0,0,0] with the len(A)=4 zeros.
2. Update the last element in D. A[3]=5. Using Skill <find_max>, max(5,0)=5. D[3]=5 and D=[0,0,0,5].
3. Update the second last element in D. A[3]=5, A[2]=1. Using Skill <find_max>, max(5,1,0)=5. D[2]=5 and D=[0,0,5,5].
4. Starting from the third last (len(A)-2=2) element in D, update each element in D based on A=[3,2,1,5] (A[0]=3,A[1]=2,A[2]=1,A[3]=5):
    i. D[3]=5, D[2]=5, A[1]=2. Using Skill <add>, A[1]+D[3]=2+5=7. Using Skill <find_max>, max(D[2],A[1]+D[3],0)=max(5,7,0)=7. D[1]=7 and D=[0,7,5,5].
    ii. D[2]=5, D[1]=7, A[0]=3. Using Skill <add>, A[0]+D[2]=3+5=8. Using Skill <find_max>, max(D[1],A[0]+D[2],0)=max(7,8,0)=8. D[0]=8 and D=[8,7,5,5].
5.  D=[8,7,5,5]. The highest sum is D[0]=8.
<C>
#### 8
<EOD>

Example #2: A=[4,3,1,5,2].
Answer:
<C> 
1. A=[4,3,1,5,2] (A[0]=4,A[1]=3,A[2]=1,A[3]=5,A[4]=2). Using Skill <list_length>, len(A)=5. Construct a list D=[0,0,0,0,0] with the len(A)=5 zeros.
2. Update the last element in D. A[4]=2. Using Skill <find_max>, max(2,0)=2. D[4]=2 and D=[0,0,0,0,2].
3. Update the second last element in D. A[4]=2, A[3]=5. Using Skill <find_max>, max(2,5,0)=5. D[3]=5 and D=[0,0,0,5,2].
4. Starting from the third last (len(A)-2=3) element in D, update each element in D based on A=[4,3,1,5,2] (A[0]=4,A[1]=3,A[2]=1,A[3]=5,A[4]=2):
    i. D[4]=2, D[3]=5, A[2]=1. Using Skill <add>, A[2]+D[4]=1+2=3. Using Skill <find_max>, max(D[3],A[2]+D[4],0)=max(5,3,0)=5. D[2]=5 and D=[0,0,5,5,2].
    ii. D[3]=5, D[2]=5, A[1]=3. Using Skill <add>, A[1]+D[3]=3+5=8. Using Skill <find_max>, max(D[2],A[1]+D[3],0)=max(5,8,0)=8. D[1]=8 and D=[0,8,5,5,2].
    iii. D[2]=5, D[1]=8, A[0]=4. Using Skill <add>, A[0]+D[2]=4+5=9. Using Skill <find_max>, max(D[1],A[0]+D[2],0)=max(8,9,0)=9. D[0]=9 and D=[9,8,5,5,2].
5. D=[9,8,5,5,2]. The highest sum is D[0]=9.
<C>
#### 9
<EOD>
Following the above examples, use your skills to answer:
'''

prompts = pd.read_csv('dp_full.csv')
# An example
prompt= prompts['prompt'][0]
answer = prompt['answer'][0]
input_dp = dp_skic_instruction + '\n' + prompt + '\nAnswer:'




#gsm8k
shorter_gsm8k_skic='''
You have the knowledge of many skills, the following are some examples:
Skill <Extract Digits>: Extract the digits in a number to a list.  Extract digits in 123 to D=[1,2,3]. Extract digits in 7654 to D=[7,6,5,4]

Skill <Add single-digits>: Add two single-digit numbers. For example, 0+0=0 0+1=1 0+2=2 0+3=3 0+4=4 0+5=5 0+6=6 0+7=7 0+8=8 0+9=9

Skill <Sub 10>: 10-10=0 11-10=1 12-10=2 13-10=3 14-10=4 15-10=5 16-10=6 17-10=7 18-10=8 19-10=9

Skill <Add 10>: -10+10=0 -9+10=1 -8+10=2 -7+10=3 -6+10=4 -5+10=5 -4+10=6 -3+10=7 -2+10=8 -1+10=9

Skill <Sub single-digits>: Subtract two single-digit numbers. For example, 0-0=0 0-1=-1 0-2=-2 0-3=-3 0-4=-4 0-5=-5 0-6=-6 0-7=-7 0-8=-8 0-9=-9

Skill <Compare 0>: 10>0 9>0 8>0 7>0 6>0 5>0 4>0 3>0 2>0 1>0 0=0 -1<0 -2<0 -3<0 -4<0 -5<0 -6<0 -7<0 -8<0 -9<0

Skill <Compare 10>: 0<10 1<10 2<10 3<10 4<10 5<10 6<10 7<10 8<10 9<10 10=10 11>10 12>10 13>10 14>10 15>10 16>10 17>10 18>10 19>10

Skill <Mul single-digits>: Multiple two single-digit numbers: 7*1=7 7*2=14 7*3=21 7*4=28 7*5=35 7*6=42 7*7=49 7*8=56 7*9=63

Skill <Add multiple numbers>: Add multiple numbers such as m+n+p: 1. Add the first two numbers m+n and get the result r1=m+n. 2. Add the third number p to r1 and get the result r2=r1+p. 
For example: Calculate 128+64+79
1. Add the first two numbers 128+64 and use Skill <Add> to get the result r1=128+64=192.
2. Add the third number 79 to r1 and use Skill <Add> to get the result r2=192+79=271.
So 128+64+79=271 

Skill <Add>: Use the skills to add two numbers.
For example: Calculate 86+964:
<C>
1. Using Skill <Extract Digits>, extract the digits in 86 to DM=[8,6]. len(DM)=2. Extract the digits in 964 to DN=[9,6,4]. len(DN)=3.
2. len(DM)=2<len(DN)=3. Align the two lists by adding len(DN)-len(DM)=1 zeros to the short list (DM): DM=[0,8,6].
3. Using Skill <Add single-digits>, add every number in DM=[0,8,6] to the corresponding number in DN =[9,6,4] to form a list, DS=[0+9,8+6,6+4]=[9,14,10].
4. Append a 0 to the beginning of DS: DS=[0,9,14,10].  Construct a list R=[0,0,0,0] with l=len(DS)=4 zeros. 
5.  DS=[0,9,14,10] (DS[0]=0, DS[1]=9, DS[2]=14, DS[3]=10), starting from DS[3] to DS[1] (DS[3]=10, DS[2]=14, DS[1]=9):
    i. DS[3]=10, R[3]=0, R[3]=R[3]+DS[3]=0+10=10. Based on Skill <Compare 10>, 10=10, R[3]=10=10, so R[2]=1 and R[3]=10-10=0 by Skill <Sub 10>. R=[R[0],R[1],R[2],R[3]]=[0,0,1,0].
    ii. DS[2]=14, R[2]=1, R[2]=R[2]+DS[2]=1+14=15. Based on Skill <Compare 10>, 15>10, R[2]=15>10, so R[1]=1 and R[2]=15-10=5 by Skill <Sub 10>. R=[R[0],R[1],R[2],R[3]]=[0,1,5,0].
    iii. DS[1]=9, R[1]=1, R[1]=R[1]+DS[1]=1+9=10. Based on Skill <Compare 10>, 10=10, R[1]=10=10, so R[0]=1 and R[1]=10-10=0 by Skill <Sub 10>. R=[R[0],R[1],R[2],R[3]]=[1,0,5,0].
6. R=[1,0,5,0]. The answer is 1050.
</C>
1050
<EOD>

Skill <Mul>: Use the skills to multiply two numbers.
For example: Calculate 184*67:
<C>
1. Using Skill <Extract Digits>, extract the digits in 184 to DM=[1,8,4]. len(DM)=3. Extract the digits in 67 to DN=[6,7]. len(DN)=2.
2. Add 0,1,len(DM)-1=2 zeros to the end of every number in DM=[1,8,4] according to the position of the number in DM: DMO=[1*100,8*10,4*1]=[100,80,4].
3. Add 0,len(DN)-1=1 zeros to the end of every number in DN=[6,7] according to the position of the number in DN: DNO=[6*10,7*1]=[60,7].
4. Using Skill <Mul single-digits>, multiple every number in DMO=[100,80,4] with every number in DNO=[60,7] and get R=[100*60,100*7,80*60,80*7,4*60,4*7]=[6000,700,4800,560,240,28].
5. Using Skill <Add multiple numbers>, add all the numbers in R=[6000,700,4800,560,240,28], 6000+700+4800+560+240+28:
    i. Add the first two numbers using Skill <Add>: r1=6000+700=6700.
    ii. Add the third number 4800 to r1=6700 using Skill <Add>: r2=6700+4800=11500.
    iii. Add the fourth number 560 to r2=11500 using Skill <Add>: r3=11500+560=12060.
    iv. Add the fifth number 240 to r3=12060 using Skill <Add>: r4=12060+240=12300.
    v. Add the sixth number 28 to r4=12300 using Skill <Add>: r5=12300+28=12328.
6. So the answer is 12328
</C>
#### 12328
<EOD>

Skill <Sub>: Use the skills to subtract a number from another number.
For example: Calculate 964-86:
<C>
1. Using Skill <Extract Digits>, extract the digits in 964 to DN=[9,6,4]. len(DN)=3. Extract the digits in 86 to DM=[8,6]. len(DM)=2.
2. len(DM)=2<len(DN)=3. Align the two lists by adding len(DN)-len(DM)=1 zeros to the short list (DM): DM=[0,8,6].
3. Using Skill <Sub single-digits>, subtract every number in DM=[0,8,6] from the corresponding number in DN=[9,6,4] to form a list, DS=[9-0,6-8,4-6]=[9,-2,-2].
4. Construct a list R=[0,0,0] with l=len(DS)=3 zeros.
5. DS=[9,-2,-2] (DS[0]=9, DS[1]=-2, DS[2]=-2), starting from DS[2] to DS[0] (DS[2]=-2, DS[1]=-2, DS[0]=9):
    i. DS[2]=-2, R[2]=0. So R[2]=DS[2]+R[2]=-2+0=. Based on Skill <Compare 0>, -2<0, so R[1]=-1 and R[2]=-2+10=8 by Skill <Add 10>. R=[R[0],R[1],R[2]] = [0,-1,8].
    ii. DS[1]=-2, R[1]=-1. So R[1]=DS[1]+R[1]=-2-1=-3. Based on Skill <Compare 0>, -3<0, so R[0]=-1 and R[1]=-3+10=7 by Skill <Add 10>. R=[R[0],R[1],R[2]] = [-1,7,8].
    iii. DS[0]=9, R[0]=-1. So R[0]=DS[0]+R[0]=9-1=8. Based on Skill <Compare 0>, 8>0, so R[0]=8. R=[R[0],R[1],R[2]]=[8,7,8].
6. R=[8,7,8]. The answer is 878.
</C>
#### 878
<EOD>

Skill <Age>: Describe the age of a person. 
If a person is P years old, Q years ago, the person was P-Q years old. 
If a person is P years old, in Q years, the person will be P+Q years old.
If person A is P years old, person B is Q years old, and person A is R years older than person B, then P=Q+R. 
If person A is P years old, person B is Q years old, and person A is R years younger than person B, then P=Q-R.

Skill <Solve Equation>: Solve an equation. 
When subtract or add the same number from both sides of the equation, the equation is still true.
When move a number from one side of the equation to the other side, the sign of the number changes. 
When move a multiplication from one side of the equation to the other side, the sign of the multiplication changes. 
When move a division from one side of the equation to the other side, the sign of the division changes.
For example, if the equation is 3x+5=7, move +5 to the other side, then 3x=7-5. Using the Skill <Sub>, 3x=7-5=2. Move 3 to the other side, then x=2/3.
If the equation is 3x-5=7, move -5 to the other side, then 3x=7+5. Using the Skill <Add>, 3x=7+5=12. Move 3 to the other side, then x=12/3=4.
If the equation is 3x*5=7, move *5 to the other side, then 3x=7/5. Using the Skill <Div>, 3x=7/5. Move 3 to the other side, then x=7/5/3=7/15.
If the equation is 3x/5=7, move /5 to the other side, then 3x=7*5. Using the Skill <Mul>, 3x=7*5=35. Move 3 to the other side, then x=35/3.
If the equation is 3x+2=x+8, move +2 to the other side, then 3x=x+8-2. Using the Skill <Sub>, 3x=x+8-2=x+6. Move x to the other side, then 3x-x=6. Using the Skill <Sub>, 2x=6. Move 2 to the other side, then x=6/2=3.


-----------------
Now, use your skills to solve the math problems. Here are some examples:
Four years ago, Kody was only half as old as Mohamed. If Mohamed is currently twice 30 years old, how old is Kody?
Answer:
<C>
1. Mohamed is currently twice 30 years old. Using the Skill <Mul>, Mohamed is currently 30*2 = 60 years old.
2. Using Skill <Age>, four years ago, Mohamed was 4 years younger than now. Using the Skill <Sub>, Mohamed was 60-4 = 56 years old. 
3. Four years ago, Kody was only half as old as Mohamed. Using the skill <Div>, Kody was 56/2 = 28 years old.
4. Using Skill <Age>, currently, Kody is 4 years older than four years ago. Using the Skill <Add>, Kody is currently 28+4 = 32 years old.
5. The answer is 32.
</C>
### 32
<EOD>

Carla bought 2 bags of mini peanut butter cups on clearance. Each bag was $6.00 but was 75% off. How much did she spend on 2 bags of candy?
Answer:
<C>
1. Each bag was 75% off. Using the Skill <Sub>, each bag is 1-0.75=0.25 of the original price.
2. Each bag was originally $6.00 and was 0.25 of the original price.. Using the Skill <Mul>, each bag cost $6.00*0.25=$1.50.
3. Carla bought 2 bags and each bag cost $1.50. Using the Skill <Mul>, she spent $1.50*2=$3.00.
4. The answer is 3.
</C>
### 3
<EOD>

If Pam is currently twice as young as Rena is, and in 10 years Rena will be 5 years older than her, how old is Pam now?
Answer:
<C>
1. Suppose Pam is currently P years old, Rena is currently R years old. Pam is currently twice as young as Rena is. Using the Skill <Age> and Skill <Mul>, R=2*P.
2. Using Skill <Age>, in 10 years, Pam and Rena will be 10 years older than now. Using the Skill <Add>, Pam will be P+10 years old, Rena will be R+10=2P+10 years old.
3. In 10 years, Rena will be 5 years older than Pam. Using the Skill <Age>, Pam will be R+10-5=2P+10-5=2P+5 years old. So Pam will be P+10 years old and 2P+5 years old in 10 years. 
4. P+10=2P+5. 
    i. Using the Skill <Solve Equation>, move P to the other side, then 10=2P-P+5. Using the Skill <Sub>, 10=2P-P+5=P+5. 
    ii. Using the Skill <Solve Equation>, move +5 to the other side, then 10-5=P. Using the Skill <Sub>, 10-5=5=P.
5. P=5. So Pam is currently 5 years old. 
6. The answer is 5.
</C>
### 5
<EOD>


Cappuccinos cost $2, iced teas cost $3, cafe lattes cost $1.5 and espressos cost $1 each. 
Sandy orders some drinks for herself and some friends. 
She orders three cappuccinos, two iced teas, two cafe lattes, and two espressos. 
How much change does she receive back for a twenty-dollar bill?
Answer:
<C>
1. Cappuccinos cost $2 abd Sandy orders three cappuccinos. Using the Skill <Mul>, Sandy spends $2*3=$6 on cappuccinos.
2. Iced teas cost $3 and Sandy orders two iced teas. Using the Skill <Mul>, Sandy spends $3*2=$6 on iced teas. Using the Skill <Add>, Sandy spends $6+$6=$12 on cappuccinos and iced teas.
3. Cafe lattes cost $1.5 and Sandy orders two cafe lattes. Using the Skill <Mul>, Sandy spends $1.5*2=$3 on cafe lattes. Using the Skill <Add>, Sandy spends $12+$3=$15 on cappuccinos, iced teas and cafe lattes.
4. Espressos cost $1 and Sandy orders two espressos. Using the Skill <Mul>, Sandy spends $1*2=$2 on espressos. Using the Skill <Add>, Sandy spends $15+$2=$17 on cappuccinos, iced teas, cafe lattes and espressos.
5. Sandy gives a twenty-dollar bill to the cashier. Using the Skill <Sub>, Sandy receives $20-$17=$3 as change.
6. The answer is 3.
</C>
### 3
<EOD>

Following the above examples, use your skills (not limited to the skills provided above) to answer the math problem:
'''
prompts = pd.read_csv('gsm8k.csv')
# An example
prompt= prompts['question'][0]
answer = prompt['answer'][0]
input_gsm8k = shorter_gsm8k_skic + '\n' + prompt + '\nAnswer:'


# math
shorter_math_skic='''
You have the knowledge of many skills, here are some examples:
Skill <Add>: Add two numbers. For example, 128+987=1115. 

Skill <Mul>: Multiply two numbers. For example, 128*76=9728. 

Skill <Sub>: Subtract a number from another number. For example, 128-67=61. 

Skill <Div>: Divide a number from another number. For example 12/3=4.

Skill <Mod>: Modulus or modulo, it finds the remainder of a division operation. For example, 10 mod 3 = 1, because 10 divided by 3 leaves a remainder of 1.

Skill <Exp>: An exponent refers to the number of times a number is multiplied by itself.  For example, in 2^3, 2 is the base and 3 is the exponent, 2^3=(2*2*2)=8. 
There are several rules: (a^n * a^m = a^(n+m)), ((a^n)^m = a^(n*m)). For example, (2^3 * 2^4) can be simplified to 2^7.

Skill <Base Conversion>: Base conversion is a way to change numbers from one base to another. 
Here is an of converting the base 2 number 1101 to base 10: 1*(2^3) + 1*(2^2) + 0*(2^1) + 1*(2^0) = 8 + 4 + 0 + 1 = 13 in base 10.

Skill <Radicals>: A radical represents the root of a number. The square root (represented by \\sqrt) is the most common radical.
A radical can be expressed as a fractional exponent. For example, \\sqrt(2) can be expressed as 2^(1/2).

Skill <Factoring>: In the context of integers, factorization involves expressing a number as the product of prime numbers. For example, the number 18 can be factored into 2 * 3 * 3. 
In the context of polynomials, here are several common cases:
Factoring out the Greatest Common Factor (GCF): The first step in factoring an expression is to check if there is a GCF that can be factored out. For example, in the expression 2x^3 + 4x^2, the GCF is 2x^2, and factoring it out gives 2x^2(x + 2).
Factoring by Grouping: This method is used when an expression has four terms. For example, in the expression x^3 + 2x^2 + x + 2, you can group the first two terms and the last two terms and factor out the GCF from each group, giving x^2(x + 2) + 1(x + 2). Then, you can factor out the common binomial to get (x^2 + 1)(x + 2).
Factoring Trinomials: This is used when an expression is in the form ax^2 + bx + c. For example, in the expression x^2 + 5x + 6, you look for two numbers that multiply to 6 and add to 5. The numbers 2 and 3 fit these criteria, so the expression factors to (x + 2)(x + 3).
Factoring Difference of Squares: This is used when an expression is in the form a^2 - b^2. For example, in the expression x^2 - 4, you can recognize that 4 is a perfect square, so the expression factors to (x + 2)(x - 2).
Factoring Perfect Square Trinomials: This is used when an expression is in the form a^2 + 2ab + b^2 or a^2 - 2ab + b^2. For example, in the expression x^2 + 4x + 4, you can recognize that this is a perfect square trinomial, so it factors to (x + 2)^2.

Skill <Solve Equation>: Solve an equation. When subtract or add the same number from both sides of the equation, the equation is still true. When move a number from one side of the equation to the other side, the sign of the number changes. 
For example, if the equation is 3x+2=x+8, move +2 to the other side, then 3x=x+8-2. Using the Skill <Sub>, 3x=x+8-2=x+6. Move +x to the other side, then 3x-x=6. Using the Skill <Sub>, 2x=6. Move *2 to the other side, then x=6/2=3.

Skill <Quadratic Formula> The quadratic formula is used to solve quadratic equations, which are equations of the form ax^2 + bx + c = 0, where a, b, and c are constants and a \\neq 0. 
The quadratic formula is: x = [-b +- sqrt(b^2 - 4ac)] / (2a). x is the solutions of the quadratic equation (also known as the roots); +- indicates that there are usually two solutions, one resulting from using the plus sign, and the other from using the minus sign.
The term under the square root, b^2 - 4ac, is called the discriminant. It determines the nature of the roots of the quadratic equation. If the discriminant is positive, the equation has two distinct real roots. If it's zero, the equation has exactly one real root (also known as a repeated root). If it's negative, the equation has two complex roots.

Skill <Complex Number>: Complex numbers are numbers that consist of a real part and an imaginary part. They are usually written in the form a + bi, where 'a' is the real part and 'bi' is the imaginary part. 'i' is the imaginary unit with the property that i^2 = -1. i^1 = i, i^2 = -1, i^3 = -i, and i^4 = 1, and the pattern repeats every four powers.
To add or subtract complex numbers, add or subtract the real parts and the imaginary parts separately. For example, (3 + 2i) + (1 + 4i) = 4 + 6i.
To multiply complex numbers, use the distributive property and remember that i^2 = -1. For example, (3 + 2i) * (1 + 4i) = 3 + 12i + 2i + 8i^2 = 3 + 14i - 8 = -5 + 14i.
To divide complex numbers, multiply the top and bottom of the fraction by the conjugate of the bottom and simplify. 
The absolute value of a complex number a + bi is the distance from the origin to the point (a,b) in the complex plane, which is sqrt(a^2 + b^2).
The complex conjugate of a complex number is obtained by changing the sign of its imaginary part. For example, the complex conjugate of 3 + 4i is 3 - 4i.

Skill <Piecewise Function: Continuous>: A piecewise function is continuous if it is continuous at every point in its domain. This means that for every point in the function's domain, the limit of the function as x approaches that point from the left is equal to the limit of the function as x approaches that point from the right, and both of these limits are equal to the value of the function at that point. For a piecewise function, this means that not only must each "piece" of the function be continuous, but also the function must be continuous at the points where the "pieces" meet. This means that the right-hand limit of one "piece" at its endpoint must be equal to the left-hand limit of the next "piece" at its starting point. 
For example, consider the piecewise function defined by: f(x) = {x^2 for x < 0, x+1 for x ≥ 0}
This function is continuous because each "piece" is a continuous function (x^2 and x+1 are both polynomials, which are always continuous), and the right-hand limit of x^2 as x approaches 0 is 0, which is equal to the left-hand limit of x+1 as x approaches 0.

Skill <Factorial>: Factorial is a function that multiplies a given number by every number below it until 1. n!=n*(n-1)*(n-2)*...*1. The factorial of 0 is defined to be 1 (0! = 1). 
For example, the factorial of 5 is calculated as: 5!=5*4*3*2*1=120

Skill <Probability>: Probability is the measure of the likelihood that an event will occur. It is quantified as a number between 0 and 1, where 0 indicates impossibility and 1 indicates certainty.

Skill <Conditional Probability>: Conditional probability is the probability of an event occurring given that another event has already occurred. If the event of interest is A and event B has already occurred, the conditional probability of A given B is usually written as P(A|B). The formula for conditional probability is: P(A|B) = P(A and B) / P(B) where P(A|B) is the conditional probability of A given B, P(A and B) is the probability of both A and B occurring, P(B) is the probability of B occurring.
For example, if you have a deck of 52 cards and you draw one card, the probability that it is a king is 4/52 or 1/13. Now, if you know that the card you drew is a face card, the conditional probability that it's a king is P(King|Face) = P(King and Face) / P(Face) = (4/52) / (12/52) = 1/3 (using the Skill <Div>).

Skill <Probability Addition Rule>: The Addition Rule in probability is used to calculate the probability of either of two events happening. The formula for the Addition Rule is: P(A or B) = P(A) + P(B) - P(A and B) where: P(A or B) is the probability of either event A or event B occurring. P(A) is the probability of event A occurring. P(B) is the probability of event B occurring. P(A and B) is the probability of both events A and B occurring.
For example, if you want to find the probability of drawing a heart or a queen from a deck of cards, you would add the probability of drawing a heart (13/52) to the probability of drawing a queen (4/52), and then subtract the probability of drawing the queen of hearts (which has been counted in both events) (1/52). So, P(Heart or Queen) = P(Heart) + P(Queen) - P(Heart and Queen) = 13/52 + 4/52 - 1/52 = 16/52 = 4/13 (Using the Skill <Add> and <Sub>)

Skill <Probability Multiplication Rule>: The multiplication rule in probability theory is a way to determine the probability of two events occurring at the same time (conjointly). The probability that events A and B both occur is P(A and B) = P(A) * P(B|A).

Skill <Counting Principle>: If there are m ways to do one thing, and n ways to do another, then there are m*n ways of doing both.

Skill <Permutations>: Permutations refer to the arrangement of items in a specific order. The formula for permutations is: P(n, r) = n! / (n-r)! , where n is the total number of items, r is the number of items to choose.
For example, if you have 5 books and you want to know in how many ways you can arrange 3 of them on a shelf, you would calculate the permutations as: P(5, 3) = 5! / (5-3)!. Using the Skill <Factorial>, <Sub> and <Div>, 5! / (5-3)! = (5*4*3*2*1)/(2*1) = 5*4*3 = 60
So, there are 60 different ways to arrange 3 books out of 5 on a shelf.

Skill <Combination>: Combinations refer to the selection of items without regard to the order. It is often used when the order doesn't matter. The formula for combinations is: C(n, r) = n! / [r!(n-r)!] , where n is the total number of items, r is the number of items to choose.
For example, if you have a deck of 52 cards and you want to know how many different 5-card hands you can draw, you would calculate the combinations as: C(52, 5) = 52!/[5!(52-5)!]. Using Skill <Factorial>, <Sub> and <Div>, 52!/[5!(52-5)!]=(52*51*50*...*1)/[(5*4*3*2*1)(47*46*...*1)]=(52*51*50*49*48)/(5*4*3*2*1) = 2,598,960
So, there are 2,598,960 different ways to draw a 5-card hand from a deck of 52 cards.

Skill <Perimeter>: The perimeter of a shape is the distance around its boundary. It is calculated by adding up the lengths of all the sides of the shape. 
Here's how to calculate the perimeter for some common shapes:
Square: The perimeter of a square is four times the length of one side (P = 4s).
Rectangle: The perimeter of a rectangle is twice the sum of the length and the width (P = 2l + 2w).
Triangle: The perimeter of a triangle is the sum of the lengths of all three sides (P = a + b + c).
Circle: The perimeter of a circle, also known as the circumference, is calculated using the formula P = 2 \\pi r, where r is the radius of the circle. Or pi times the diameter (C = \\pi d).

Skill <Area>: The area of a shape is the amount of space that it covers. It is measured in square units. 
Here's how to calculate the area of some common shapes:
Square: The area of a square is the length of one side squared (s^2). So if the length of one side is 4 units, the area is 4^2 = 16 square units.
Rectangle: The area of a rectangle is the length times the width (l*w). So if the length is 5 units and the width is 3 units, the area is 5*3 = 15 square units.
Triangle: The area of a triangle is half the base times the height (1/2*b*h). So if the base is 6 units and the height is 4 units, the area is 1/2*6*4 = 12 square units.
Circle: The area of a circle is pi times the radius squared (\\pi*r^2). So if the radius is 3 units, the area is \\pi*3^2 = 9\\pi square units.
Parallelogram: The area of a parallelogram is the base times the height (b*h). So if the base is 7 units and the height is 5 units, the area is 7*5 = 35 square units.
Trapezoid: The area of a trapezoid is half the sum of the bases times the height (1/2*(b1+b2)*h). So if the bases are 8 and 6 units and the height is 4 units, the area is 1/2*(8+6)*4 = 28 square units.
Rhombus: The area of a rhombus can be calculated using the following formula: Area = (Diagonal1 * Diagonal2) / 2, where Diagonal1 and Diagonal2 are the lengths of the two diagonals of the rhombus.

Skill <Volume>: Volume is the measure of the amount of space that a three-dimensional object occupies. It is often measured in cubic units.
Here are the formulas for the volume of some common three-dimensional shapes:
Cube: Volume = side^3
Rectangular Prism: Volume = length * width * height
Cylinder: Volume = \\pi r^2h (where r is the radius of the base and h is the height)
Cone: Volume = 1/3 \\pi r^2h (where r is the radius of the base and h is the height)
Sphere: Volume = 4/3 \\pi r^3 (where r is the radius)

Skill <Prime Numbers>: A prime number is a natural number greater than 1 that has no positive divisors other than 1 and itself. For example, the first six prime numbers are 2, 3, 5, 7, 11, and 13. 
Every natural number greater than 1 is either a prime number or can be factorized into prime numbers. The number 1 is not considered a prime number. The number 2 is the only even prime number. 

Skill <Composite Numbers>: Composite numbers are positive integers that have at least one positive divisor other than one or the number itself. For example, the number 4 is a composite number because it has factors of 1, 2, and 4. 
The number 1 is not considered a composite number. Prime numbers are also not considered composite numbers.
Composite numbers can be even or odd, and they can be represented as the product of their factors. For example, the number 12 is a composite number because it can be represented as 2*2*3 or 2*6 or 3*4. 

Skill <GCD>: The Greatest Common Divisor (GCD), also known as the Greatest Common Factor (GCF), of two or more integers is the largest positive integer that divides each of the integers without a remainder. 
For example, the GCD of 8 and 12 is 4, because 4 is the largest positive integer that can divide both 8 and 12 without a remainder.
Here's an example of how to find the GCD of two numbers:
Let's find the GCD of 48 and 18:
1. Divide the larger number by the smaller number. Using the Skill <Div> and <Mod>, 48/18 = 2 remainder 12.
2. Then divide the divisor by the remainder. Using the Skill <Div> and <Mod>, 18/12 = 1 remainder 6.
3. Continue this process until the remainder is 0. Using the Skill <Div> and <Mod>, 12/6 = 2 remainder 0.
4. The last non-zero remainder is the GCD. So, the GCD of 48 and 18 is 6.

Skill <LCM>: The Least Common Multiple (LCM) of two integers is the smallest positive integer that is divisible by both numbers without leaving a remainder. In other words, it's the smallest common multiple of the two numbers.
For example, the LCM of 5 and 12 is 60, because 60 is the smallest number that both 5 and 12 can divide into evenly.
There are several ways to find the LCM of two numbers: The LCM of two numbers a and b can also be found by dividing the product of the two numbers by their Greatest Common Divisor (GCD). So LCM(a, b) = |a*b| / GCD(a, b).
For example, to find the LCM of 18 and 24:
1. Using the Skill <GCD>, first find the GCD of 18 and 24, which is GCD(18,24)=6. 
2. Then divide the product of 18 and 24 by 6 to get the LCM. Using the Skill <Mul> and <Div>, LCM(18, 24) = (18*24) / 6 = 72.

Skill <Congruences>: Two integers a and b are said to be congruent modulo n if they have the same remainder when divided by n. This is often written as a \\equiv b (mod n), which is read as "a is congruent to b modulo n."
For example, 17 and 2 are congruent modulo 5, because when you divide each of them by 5, you get a remainder of 2. So, we can write 17 \\equiv 2 (mod 5).
Here are some properties of congruences:
Reflexivity: For any integer a and any positive integer n, a \\equiv a (mod n).
Symmetry: For any integers a and b and any positive integer n, if a \\equiv b (mod n), then b \\equiv a (mod n).
Transitivity: For any integers a, b, and c and any positive integer n, if a \\equiv b (mod n) and b \\equiv c (mod n), then a \\equiv c (mod n).
Addition: If a \\equiv b (mod n) and c \\equiv d (mod n), then a + c \\equiv b + d (mod n).
Multiplication: If a \\equiv b (mod n) and c \\equiv d (mod n), then ac \\equiv bd (mod n).

-----------------

Now, use your skills to solve the math problems. Here are some examples:
Let \\[f(x) = \\left\\{\n\\begin{array}{cl} ax+3, &\\text{ if }x>2, \\\\\nx-5 &\\text{ if } -2 \\le x \\le 2, \\\\\n2x-b &\\text{ if } x <-2.\n\\end{array}\n\\right.\\]Find $a+b$ if the piecewise function is continuous (which means that its graph can be drawn without lifting your pencil from the paper).
Answer:
<C>
1. If the piecewise function is continuous, using the skill <Piecewise Function: Continuous>, the function must be continuous at the points where the "pieces" meet. So when x=2, ax+3=x-5. When x=-2. x-5=2x-b.
2. When x=2, ax+3=x-5. Substitute x with 2, a(2)+3=2-5. Using the Skill <Mul> and <Sub>, 2a+3=-3.
    i. Using the Skill <Solve Equation>, move +3 to the other side, 2a=-3-3. Using the Skill <Add>, 2a=-3-3=-6.
    ii. Using the Skill <Solve Equation>, move *2 to the other side, a=(-6)/2. Using the Skill <Div>, a=(-6)/2=-3.
    iii. a=-3.
3. When x=-2, x-5=2x-b. Substitute x with -2, -2-5=2(-2)-b. Using the skill <Add> and <Mul>, -7=-4-b.
    i. Using the Skill <Solve Equation>, move -b to the other side, b-7=-4.
    ii. Using the Skill <Solve Equation>, move -7 to the other side, b=-4+7. Using the Skill <Add>, b=3.
    iii. b=3.
4. a=-3 and b=3. Using the Skill <Add>, a+b=(-3)+3=0 
5. The answer is 0.
</C>
#### 0
<EOD>

The Smith family has 4 sons and 3 daughters. In how many ways can they be seated in a row of 7 chairs such that at least 2 boys are next to each other?
Answer:
<C>
1. The Smith family has 4 sons and 3 daughters. To count the number ways such that at least 2 boys are next to each other, we first count the ways where there are no boys sitting next to each other.
2. The only distribution that has no boys together is (B G B G B G B) where B refers to boys and G refers to girls.
    i. Using the Skill <Permutations>, there are P(4,4)=4! to assign boys. Using the Skill <Factorial>, 4!=4*3*2*1=24. So there are 24 ways to assign boys.
    ii. Using the Skill <Permutations>, there are P(3,3)=3! to assign girls. Using the Skill <Factorial>, 3!=3*2*1=6. So there are 6 ways to assign boys.
    iii. Using the Skill <Counting Principle>, there are 24*6=144 ways to assign boys and girls such that no boys are next to each other.
3. Using the Skill <Permutations>, there are P(7,7)=7! ways to seat everyone. Using the Skill <Factorial>, 7!=7*6*5*4*3*2*1=5040. So there are 5040 ways to assign everyone.
4. As a result, the number of ways where there are at least 2 boys are next to each other is the total ways except the case where there are no boys sitting next to each other. Using the Skill <Sub>, there are 5040-144=4896 ways.
5. The answer is 4896.
</C>
#### 4896
<EOD>

A round pizza is $\\frac13$ of an inch thick and has a diameter of 12 inches. It is cut into 12 congruent pieces. What is the number of cubic inches in the volume of one piece? Express your answer in terms of $\\pi$.
Answer:
<C>
1. A round pizza is $\\frac13$ of an inch thick, the height of the round pizza is 1/3 inch.
2. A round pizza has a diameter of 12 inches. The radius of the round pizza is half of the diameter. Using the Skill <Div> so r=12/2=6 inches.
3. The round pizza is a cylinder, using the Skill <Volume>, the volume of the pizza is  V = \\pi r^2h = \\pi * 6^2 * (1/3) cubic inches. Using the Skill <Mul> and <Exp>, the volume of the pizza is \\pi * 6^2 * (1/3)=12 \\pi cubic inches.
4. The pizza is cut into 12 congruent pieces, one slice has 1/12 of this volume. Using the Skill <Div>, the volume of one piece is 12 \\pi/12 = \\pi cubic inches.
5. The answer is \\pi.
</C>
#### \\pi
<EOD>

Shown below are rows 1, 2, and 3 of Pascal's triangle.\n\n\\[\n\\begin{array}{ccccccc}\n& & 1 & & 1 & & \\\\\n& 1 & & 2 & & 1 & \\\\\n1 & & 3 & & 3 & & 1\n\\end{array}\n\\]Let $(a_i),$ $(b_i),$ $(c_i)$ be the sequence, from left to right, of elements in the 2005th, 2006th, and 2007th rows, respectively, with the leftmost element occurring at $i = 0.$  Compute\n\\[\\sum_{i = 0}^{2006} \\frac{b_i}{c_i} - \\sum_{i = 0}^{2005} \\frac{a_i}{b_i}.\\]
Answer:
<C>
1. Using the Skill <Pascal's Triangle>, the number in the n-th row and k-th column of the Pascal's triangle is C(n,k).
2. Suppose (a_i), (b_i), (c_i) represent the entries in rows n - 1, n, n + 1 of Pascal's triangle. a_i = C(n-1, i), b_i = C(n, i), c_i = C(n+1, i)
3. Using the Skill <Combination>, \\sum_{i = 0}^{2006} \\frac{b_i}{c_i} = \\sum_{i = 0}^{2006} \\frac{\\binom{2006}{i}}{\\binom{2007}{i}} = \\sum_{i = 0}^{2006} \\frac{2007 - i}{2007} = 2007 - \\frac{2006 \\cdot 2007}{2 \\cdot 2007} = 2007-(2006*2007)/(2*2007) = 2007-1003 = 1004.
4. Using the Skill <Combination>, \\sum_{i = 0}^{2005} \\frac{a_i}{b_i} = \\sum_{i = 0}^{2005} \\frac{\\binom{2005}{i}}{\\binom{2006}{i}} = \\sum_{i = 0}^{2005} \\frac{2006 - i}{2006} = 2006 - \\frac{2005 \\cdot 2006}{2 \\cdot 2006} = 2006-(2005*2006)/(2*2006) = 2006-1002.5 = 1003.5.
5. Using the Skill <Sub>, \\[\\sum_{i = 0}^{2006} \\frac{b_i}{c_i} - \\sum_{i = 0}^{2005} \\frac{a_i}{b_i}\\] = 1004-1003.5=0.5
6. The answer is 0.5.
</C>
#### 0.5
<EOD>

Determine the number of positive integers $a$ less than $12$ such that the congruence $ax\\equiv 1\\pmod{12}$ has a solution in $x$.
Answer:
<C>
1. Using the Skill <Congruences>, the congruence $ax\\equiv 1\\pmod{12}$ has a solution in $x$ if and only if $a$ is relatively prime to $12$.
2. Using the Skill <Prime Numbers>, the positive integers less than 12 that are relatively prime to 12 are 1, 5, 7, 11. There are 4 such numbers.
3. The answer is 4.
</C>
#### 4
<EOD>

Megan has lost Fatima's phone number. Megan knows that the first three digits are either 296 or 299. The remaining four digits are 0, 1, 6 and 7, but she isn't sure of the order of these digits. If Megan randomly dials a seven-digit number that meets these conditions, what is the probability that she dials Fatima's correct number? Express your answer as a common fraction.
Answer: 
<C>
1. The first three digits are either 296 or 299. So there are 2 possibilities for the first three digits.
2. The remaining four digits are 0, 1, 6 and 7. Using the Skill <Permutations>, there are P(4,4)=4! ways to arrange these four digits. Using the Skill <Factorial>, 4!=4*3*2*1=24. So there are 24 ways to arrange the last four digits.
3. Using the Skill <Counting Principle> and <Mul>, there are 2*24=48 possible seven-digit numbers that Megan could dial.
4. Only one of these numbers is Fatima's correct number. So the probability that Megan dials the correct number is 1 out of 48. Using the Skill <Probability>, the probability is 1/48.
5. The answer is 1/48.
</C>
#### 1/48
<EOD>

Let $P$ be a point on the line\n\\[\\begin{pmatrix} 3 \\\\ -1 \\\\ 2 \\end{pmatrix} + t \\begin{pmatrix} 2 \\\\ -2 \\\\ 1 \\end{pmatrix}\\]and let $Q$ be a point on the line\n\\[\\begin{pmatrix} 0 \\\\ 0 \\\\ 4 \\end{pmatrix} + s \\begin{pmatrix} 1 \\\\ 2 \\\\ -1 \\end{pmatrix}.\\]Find the shortest possible distance $PQ.$
Answer:
<C>
1. Using the Skill <Graphing Skills>, for the first line, we can write $P$ as$(2t + 3, -2t - 1, t + 2).$ For the second line, we can write $Q$ as $(s, 2s, -s + 4).$
2. Using the Skill <Distance Formula>, PQ^2 = ((2t + 3) - (s))^2 + ((-2t - 1) - (2s))^2 + ((t + 2) - (-s + 4))^2 = 6s^2 + 6st + 9t^2 - 6s + 12t + 14.
3. Using the Skill <Factoring>, PQ^2 = 6s^2 + 6st + 9t^2 - 6s + 12t + 14 = (s + 3t + 2)^2 + 5s^2 - 10s + 10 = (s + 3t + 2)^2 + 5(s^2 - 2s + 1) + 5 = (s + 3t + 2)^2 + 5(s - 1)^2 + 5.
4. Using the Skill <Inequality>, PQ^2 = (s + 3t + 2)^2 + 5(s - 1)^2 + 5 \\ge 5. Thus, using the Skill <Radicals>, the minimum value of $PQ$ is \\sqrt{5}.
5. The answer is \\sqrt{5}.
</C>
#### \\sqrt{5}
<EOD>

Following the above examples, use your skills (not limited to the skills provided above) to answer the math problem:
'''
prompts = pd.read_csv('math_test.csv')
# An example
prompt= prompts['problem'][0]
answer = prompt['solution'][0]
input_math = shorter_math_skic + '\n' + prompt + '\nAnswer:'



