
# PED-X-Bench: FDA Pediatric Drug Extrapolation Dataset

This repository contains the dataset, benchmark tasks, and baseline models for ICLR 2026.

> **PED-X-Bench: A Dataset for Modeling FDA Pediatric Drug Extrapolation Decisions**
The main dataset is provided as a csv file: data/pedx_dataset.csv

This file contains 737 labeled FDA drug applications annotated with four extrapolation outcomes (Full, Partial, None, Unlabeled), along with concise efficacy and PK/safety summaries and harmonized study metadata.



## Quick-start: reproduce the BigBird baseline

### 1. Create a clean environment
conda create -n pedx-bench python=3.10 -y
conda activate pedx-bench
pip install -r requirements.txt          # transformers[torch], datasets, accelerate, evaluate, scikit-learn, sentencepiece

### 2. Train for four epochs (≈20 min on 1 × A100; CPU works but is slower)
```
python scripts/train_bigbird.py \
       --split_dir data/processed/splits \
       --txt_dir   data/raw/txt \
       --out_dir   checkpoints/bigbird_demo \
       --epochs    4
```
The script prints dev metrics every 100 steps and writes:
checkpoints/bigbird_demo/
  ├── config.json
  ├── pytorch_model.bin
  ├── tokenizer.json
  └── test_metrics.json

## Evaluate the saved model

```
python scripts/eval_bigbird.py \
       --model_dir checkpoints/bigbird_demo \
       --split_csv data/processed/splits/test.csv \
       --txt_dir   data/raw/txt
```
      
