import numpy as np

FIRST_TIME_USAGE = True


def first_time_usage_log():
    global FIRST_TIME_USAGE
    if FIRST_TIME_USAGE:
        print(
            "\n+---------------------------------------------------------------------+"
        )
        print("|We are using the package TQuant implemented by Datakalab.            |")
        print("|This implementation is based on an exploratory idea.                 |")
        print("|Any [WARNING] message indicates that a problem was encountered       |")
        print("|during the quantization process. In such instance, the output        |")
        print("|is not quantized and correspond to the original input weight tensor. |")
        print(
            "+---------------------------------------------------------------------+\n"
        )
    FIRST_TIME_USAGE = False


def check_inputs(W: np.ndarray, layer_type: str, bits: int) -> bool:
    """
    check that the inputs are valid (to avoid types conflicts)
    """
    quantized = True
    if not isinstance(W, np.ndarray):
        print(
            f"[WARNING] in TQuant : weights provided is not a numpy array but is {type(W)}"
        )
        quantized = False
    if not isinstance(layer_type, str):
        print(
            f"[WARNING] in TQuant : layer_type provided is not a string but is {type(layer_type)}"
        )
        quantized = False
    if not isinstance(bits, int):
        print(
            f"[WARNING] in TQuant : bits provided is not an integer array but is {type(bits)}"
        )
        quantized = False
    return quantized
