from typing import Any


def get_activation(core_activation: Any, extra_activation: Any) -> str:
    """
    This function extracts the activation function from a layer
    """
    if extra_activation is None:
        return core_activation
    return extra_activation.get_config()["activation"]


def convert_num_bits_to_range(num_bits: int) -> int:
    """
    Given a number of bits for quantization representation e.g. 1 bit, 2 bit,...
    This function returns the corresponding value M such that the quantization
    in num_bits bits should have support [-M;M]
    """
    if num_bits <= 2:
        return 1
    else:
        return 2 ** (num_bits - 1) - 1
