import tensorflow as tf


def quantize_tensor(x: tf.Variable, s: tf.Variable, bits: int) -> tf.Variable:
    """
    simply perform
    x -> round(clip(x * s))
    """
    return tf.math.round(
        tf.clip_by_value(
            t=x * s,
            clip_value_min=-(2 ** (bits - 1)) + 1,
            clip_value_max=(2 ** (bits - 1)) - 1,
        )
    )

def dequantize_tensor(x:tf.Variable, s: tf.Variable)->tf.Variable:
    """
    simply perform
    x -> x/s
    """
    return x / (tf.maximum(s, 1.0e-4))
    