"""
Here are the dependencies:
+-----------------------------------------------+
|           package           | current version |
+-----------------------------------------------+
|          tensorflow         |      2.10.0     |
|          matplotlib         |      3.6.0      |
|             cv2             |      4.5.2      |
|            scipy            |      1.9.1      |
|          nvidia_smi         |     7.352.0     |
| batch_normalization_folding |      1.0.0      |
|      tensorflow_addons      |      0.18.0     |
|          vit_keras          |      0.1.0      |
|        tensorflow_hub       |      0.12.0     |
|     tensorflow_datasets     |      4.6.0      |
|       tensorflow_text       |      2.10.0     |
|           official          |      2.9.2      |
+-----------------------------------------------+

models are stored at:
	resnet -> https://drive.google.com/file/d/1PDo1ZV73VmHp6oLuXR_UrcgB5874P-Bz/view?usp=sharing
	vit -> https://drive.google.com/file/d/1kkqVsfu9w0kEPW7JXdcgAptASWRd4oIE/view?usp=sharing
"""
from CustomLayers.QCA_FFN_Block import *
from CustomLayers.QConv2D import *
from CustomLayers.QCreateTransformerLayers import *
from CustomLayers.QDense import *
from CustomLayers.QInitializers import *
from CustomLayers.QLinear import *
from CustomLayers.QOverflow import *
from CustomLayers.QStochasticDepth import *
from CustomLayers.QUpdateEMA import *
from CustomLayers.QClassAttn import *
from CustomLayers.QCreateBasicExprLayer import *
from CustomLayers.QGeLU import *
from CustomLayers.QLayerNormalization import *
from CustomLayers.QMHSADeiT import *
from CustomLayers.QSA_FFN_Block import *
from CustomLayers.QTalkingHeadAtt import *
from CustomLayers.QUtils import *
from CustomLayers.QAdd import *
from CustomLayers.QConfig import *
from CustomLayers.QCreateLayers import *
from CustomLayers.QDeiTBlock import *
from CustomLayers.QGradients import *
from CustomLayers.QLayerScale import *
from CustomLayers.QMultiHeadSelfAttention import *
from CustomLayers.QSoftmax import *
from CustomLayers.QTransformerBlock import *
import tensorflow as tf

quantized_resnet = tf.keras.models.load_model("resnet.h5")
quantized_resnet.summary()
quantized_vit = tf.keras.models.load_model("vit.h5")
quantized_vit.summary()
