import importlib
import inspect
import os

import clip_interrogator
import open_clip
import torch
from torch import nn

class ClipInterrogator(nn.Module):

    def __init__(self, CFG):
        super().__init__()




def get_configs(CFG):
    model_config = clip_interrogator.Config(clip_model_name=CFG.ci_clip_model_name)
    model_config.cache_path = CFG.cache_path

    clip_model = open_clip.create_model(CFG.clip_model_name, device=torch.device(CFG.device), precision='fp16' if CFG.device == 'cuda' else 'fp32',
                                        pretrained=CFG.clip_model_path)
    clip_model.to(CFG.device).eval()
    clip_preprocess = open_clip.image_transform(
        clip_model.visual.image_size,
        is_train=False,
        mean=getattr(clip_model.visual, 'image_mean', None),
        std=getattr(clip_model.visual, 'image_std', None),
    )

    model_config.clip_model = clip_model
    model_config.clip_preprocess = clip_preprocess

    blip_path = inspect.getfile(blip)

    fin = open(blip_path, "rt")
    data = fin.read()
    fin.close()

    fin = open(blip_path, "wt")
    fin.write(data)
    fin.close()

    # reload module
    importlib.reload(blip)
    model_config.caption_model_name = CFG.blip_model_path
    return model_config
