We build off of a few different open-source libraries:
  - [rlkit](https://github.com/vitchyr/rlkit)
  - [multiworld](https://github.com/vitchyr/multiworld/)
  - [metaworld](https://github.com/rlworkgroup/metaworld)
  - [roboverse](https://github.com/avisingh599/roboverse)

The experiments are under `experiments`

# Installation
```
$ conda env create -f smac.yml
$ source activate smac
(smac) $ pip install -e rlkit
(smac) $ pip install -e bullet-manipulation
(smac) $ pip install -e multiworld
(smac) $ pip install git+git://github.com/rlworkgroup/metaworld.git@cfd837e3
```

# Running Experiments

## Data generation
To run the code, you need to first generate the dataset:

```
(smac) $ python experiments/data_gen_cheetah_vel.py
```

this will generate a directory of the form

```
/tmp
    /{date}_cheetah_make_dataset
        /run0_{time}
            extra_snapshot50.cpkl
```

You can change where this is saved by modifying `rlkit/launchers/config.py`

## Running SMAC
Modify the launch scripts to point to the path of the generated data (look for
the "TODO" comment. Once this is modified, you can train the poicy
```
(smac) $ python experiments/smac_cheetah_vel.py
```

The process is the same for the Ant Direction task. For Sawyer Manipulation,
the data geneartion script will create a directory rather than a `*.cpkl`
object.
