# EDPose
This is a cleaned version of our EDPose models for ICLR23 blind review only.

## Quick start

### Installation

1. Clone/Copy this repo.
2. We test our models under ```python=3.7.3,pytorch=1.9.0,cuda=11.1```. Other versions might be available as well.

- Build your own env:

   1.  Install Pytorch and torchvision

        Follow the instrction on https://pytorch.org/get-started/locally/.
        ```sh
        # an example:
        conda install -c pytorch pytorch torchvision
        ```

   2. Install other needed packages
        ```sh
        pip install -r requirements.txt
        ```

   3. Compiling CUDA operators(Deformable Attention)
        ```sh
        cd models/dino/ops
        TORCH_CUDA_ARCH_LIST="8.0" CUDA_HOME=/path/to/your/cuda_home python setup.py build install
        # unit test (should see all checking is True)
        python test.py
        cd ../../..
        ```
### Training on COCO:
#### Single Process
```
export EDPOSE_COCO_PATH=/path/to/your/cocodir
  python main.py \
 --output_dir "logs/edpose" \
 -c config/edpose.py \
 --options num_box_decoder_layers=2 batch_size=4 epoch=60 lr_drop=55 use_ema=TRUE \
   dataset_file="coco" num_body_points=17 backbone='resnet50'
```

#### Distributed Run
```
export EDPOSE_COCO_PATH=/path/to/your/cocodir
python -m torch.distributed.launch --nproc_per_node=4 main.py \
 --output_dir "logs/edpose_coco" \
 -c config/edpose.py \
 --options num_box_decoder_layers=2 batch_size=4 epoch=60 lr_drop=55 use_ema=TRUE \
   dataset_file="coco" num_body_points=17 backbone='resnet50'
```
### Training on CrowdPose:
#### Single Process
```
export EDPOSE_CrowdPose_PATH=/path/to/your/crowdpose_dir
  python main.py \
 --output_dir "logs/edpose_crowdpose" \
 -c config/edpose.py \
 --options num_box_decoder_layers=2 batch_size=4 epoch=80 lr_drop=75 use_ema=TRUE \
 dataset_file="crowdpose" num_body_points=14 backbone='resnet50'
```

#### Distributed Run
```
export EDPOSE_CrowdPose_PATH=/path/to/your/crowdpose_dir
python -m torch.distributed.launch --nproc_per_node=4 main.py \
  --output_dir "logs/edpose_crowdpose" \
 -c config/edpose.py \
 --options num_box_decoder_layers=2 batch_size=4 epoch=80 lr_drop=75 use_ema=TRUE \
 dataset_file="crowdpose" num_body_points=14 backbone='resnet50'
```
**For training with SwinL, you can directly change the "resnet50" to "swin_L_384_22k". You should put the corresponding pretrained model on ImageNet in "./pretrain_model/swin_large_patch4_window12_384_22k.pth".**

### Data Preparation
**For COCO data**, please download from [COCO download](http://cocodataset.org/#download). 2017 Train/Val is needed for COCO keypoints training and validation. 
Your cocodir should look like this:
```
|-- EDPose
`-- |-- cocodir
    `-- |-- annotations
        |   |-- person_keypoints_train2017.json
        |   `-- person_keypoints_val2017.json
        `-- images
            |-- train2017
            |   |-- 000000000009.jpg
            |   |-- 000000000025.jpg
            |   |-- 000000000030.jpg
            |   |-- ... 
            `-- val2017
                |-- 000000000139.jpg
                |-- 000000000285.jpg
                |-- 000000000632.jpg
                |-- ... 
```

**For CrowdPose data**, please download from [CrowdPose download](https://github.com/Jeff-sjtu/CrowdPose#dataset), Train/Val is needed for CrowdPose keypoints training and validation.
Download and extract them under ED-Pose/crowdpose_dir, and make them look like this:
```
|-- ED-Pose
`-- |-- crowdpose_dir
    `-- |-- json
        |   |-- crowdpose_train.json
        |   |-- crowdpose_val.json
        |   |-- crowdpose_trainval.json (generated by tools/crowdpose_concat_train_val.py)
        |   `-- crowdpose_test.json
        `-- images
            |-- 100000.jpg
            |-- 100001.jpg
            |-- 100002.jpg
            |-- 100003.jpg
            |-- 100004.jpg
            |-- 100005.jpg
            |-- ... 
```