## Code Usage
### Requirement
See ``requirements.txt``

### Distance Prediction

**Dataset generation.** To generate the dataset, step into ``./data_utils`` and run
```
python generate_random_graphs.py --out_path=../data/distance/ --connected --acyclic --n_train=16,64 --n_valid=64,72 --n_test=72,84
```
to generate directed acyclic graphs. To generate regular directed graphs, remove '--acyclic'. By default the node pairs are lalelled with shortest path distance. 
To generate longest path distance or walk profile, set DIST='lpd' or 'wp' at Line 41 of generate_random_graphs.py. 


After finishing dataset generation, run ``run_ca_spd.sh`` to reproduce the shortest path distance results for Multi-q Mag-PE on connected, acyclic directed graphs. 
Others scripts ``run_ca_lpd.sh``, ``run_ca_wp.sh``, ``run_c_spd.sh``,``run_c_lpd.sh``,``run_c_wp.sh`` can reproduce other results correspondingly.


### Sorting Network
**Dataset generation.** To generate the dataset, step into ``./data_utils`` and run
```
python generate_sorting.py
```

After finish dataset generation, run ``run_sort.sh`` to reproduce the result of Multi-q Mag-PE.



### Circuit Property Prediction
The code for this part is in an independent directory ``./EDA_benchmark``. Step into `./EDA_benchmark` as the first step.

To reproduce the results of Open Circuit Benchmark, run ``run_amp.sh``. By default the target is Gain and backbone GNN is BIGINE. To get results of other targets, 
set ``target=bw`` or ``target=pm`` at Line 5 of ``run_amp.sh``. To change backbone GNN to GINE, set ``gine_config=gine_10q001``.


To reproduce the results of High-level synthesis, run ``run_hls.sh``.


 