# Research Package Collection

This is a multi-package repository. The instructions for building and using each package will be written in the README.md
written for each package in their respective directories.

The current list of packages are:

- `ai-modules` - this is the master collection of models, tasks and datasets that can be used to run the machine learning experiments.
- `extension-cpp` - this package contains a collection of pytorch operators that extend the existing functionality of pytorch with accelerated cpp and cuda codes.

## Installation

The CUDA operator makes creating a universal installation script almost impossible.
I have thus created makefile targets for the different installation options.
I have tested working codebase on `pytorch==2.4.0+cu12.1`. Follow the steps below

## Conda / Virtual Environment

NOTE: Virtual environments can be finicky to work with. There are some torch compilations that cause issues in the 
build process. It is a faster process than a container but has a bigger chance of error.

1. verify and set all the environment variables in the .env file `source .env`
2. create a **fresh** cuda environment and install the pytorch and cuda version and activate it
3. If the pytorch or cuda version is different from above, update the constraints.txt file accordingly
4. do `make build` to install all the required packages. If this does not work for any reason, check the Makefile and run each individual command.

## Running experiments

- To run the scaling benchmarks of the cuda kernel, do `make cuda_benchmark`
- To run the algorithmic tasks, do `make algorithmic_tasks`
- To run the Time series classification tasks, do `make ts_classification`
- To run the Time series regresssion benchmark, do `make ts_regression`
