## Features


### Attacks

**Poisoning attacks**

See [poison_tool_box/](poison_tool_box/) and [create_poisoned_set.py](create_poisoned_set.py).

- `none`: no attack
- `badnet`: basic attack with badnet patch trigger, http://arxiv.org/abs/1708.06733
- `blend`: basic attack with a single blending trigger, https://arxiv.org/abs/1712.05526
- `trojan`: basic attack with the patch trigger from trojanNN, https://docs.lib.purdue.edu/cgi/viewcontent.cgi?article=2782&context=cstech
- `clean_label`: http://arxiv.org/abs/1912.02771
- `SIG`: https://arxiv.org/abs/1902.11237
- `dynamic`: http://arxiv.org/abs/2010.08138
- `ISSBA`: invisible backdoor attack with sample-specific triggers, https://openaccess.thecvf.com/content/ICCV2021/papers/Li_Invisible_Backdoor_Attack_With_Sample-Specific_Triggers_ICCV_2021_paper.pdf
- `WaNet`: imperceptible warping-based backdoor attack, http://arxiv.org/abs/2102.10369
- `TaCT`: source specific attack, https://arxiv.org/abs/1908.00686
- `adaptive_blend`: Adap-Blend attack with a single blending trigger, https://openreview.net/forum?id=_wSHsgrVali
- `adaptive_patch`: Adap-Patch attack with `k`=4 different patch triggers, https://openreview.net/forum?id=_wSHsgrVali
- `badnet_all_to_all`: All-to-all BadNet attack

To set up and launch the poisoning attacks, see **Quick Start** for a demonstration.

**Other attacks**

- `FT`: finetuning backdoor attack (see [finetune_on_poisoned_set.py](finetune_on_poisoned_set.py))
  - e.g.
        
    ```bash
    python finetune_on_poisoned_set.py -dataset cifar10 -poison_type blend
    ```

Others see [other_attacks_tool_box/](other_attacks_tool_box/) and [other_attack.py](other_attack.py).
- `bpp`: https://ieeexplore.ieee.org/document/9879477/
- `TrojanNN`: https://docs.lib.purdue.edu/cgi/viewcontent.cgi?article=2782&context=cstech
- `SRA`: https://openaccess.thecvf.com/content/CVPR2022/papers/Qi_Towards_Practical_Deployment-Stage_Backdoor_Attack_on_Deep_Neural_Networks_CVPR_2022_paper.pdf
  - e.g.
        
    ```bash
    python other_attack.py -dataset cifar10 -poison_type bpp
    python other_attack.py -dataset cifar10 -poison_type trojannn
    python other_attack.py -dataset cifar10 -poison_type SRA
    ```


### Defenses

See [other_defenses_tool_box/](other_defenses_tool_box/) and [other_defense.py](other_defense.py).

- `FP`: Fine-Pruning, http://arxiv.org/abs/1805.12185
- `NC`: Neural Clenase, https://ieeexplore.ieee.org/document/8835365/
- `MOTH`: https://ieeexplore.ieee.org/iel7/9833550/9833558/09833688.pdf?casa_token=yRH-GWs3w7gAAAAA:tLSBK60ZLJoJp__40ZIwne0G_NjSQCFNRCHiqeQeliaudHFnWq1EdBYCBJ4nnOHZaOo0kLKaimg4
- `NAD`: Neural Attention Distillation, https://arxiv.org/abs/2101.05930
- `STRIP`: http://arxiv.org/abs/1902.06531
- `AC`: Activation Clustering, https://arxiv.org/pdf/1811.03728
- `Frequency`: https://ieeexplore.ieee.org/document/9710118/
- `ScaleUp`: https://openreview.net/forum?id=o0LFPcoFKnr



## Quick Start

For example, to launch and defend against the Blend poisoning attack:
```bash
# Create a clean set
python create_clean_set.py -dataset=cifar10

# Create a noisy test set (for reporting AUROC)
python create_noisy_test_set.py -dataset=cifar10

# Create a poisoned training set
python create_poisoned_set.py -dataset=cifar10 -poison_type=blend -poison_rate=0.003

# Train on the poisoned training set
python train_on_poisoned_set.py -dataset=cifar10 -poison_type=blend -poison_rate=0.003

# Test the backdoor model
python test_model.py -dataset=cifar10 -poison_type=blend -poison_rate=0.003

# Launch BaDExpert defense to filter backdoor inputs
python unlearn.py -dataset=cifar10 -poison_type=blend -poison_rate=0.003

# Conduct other baseline post-development defenses
## $DEFENSE = ['FP', 'NC', 'MOTH', 'NAD', 'STRIP', 'AC', 'Frequency', 'ScaleUp']
python other_defense.py -defense=$DEFENSE -dataset=cifar10 -poison_type=blend -poison_rate=0.003
```

**Notice**:

- For `clean_label` attack, run [data/cifar10/clean_label/setup.sh](data/cifar10/clean_label/setup.sh) before the first time launching it.
- For `dynamic` attack, download pretrained generators `all2one_cifar10_ckpt.pth.tar` and `all2one_gtsrb_ckpt.pth.tar` to [models/](models/) from https://drive.google.com/file/d/1b8-1Susq5vk_QXadLS9pH45F68z3FAOS/view before the first time launching it.

The attacks in our primary experiments can be set up via commands like the following:
```bash
# CIFAR10
python create_poisoned_set.py -dataset cifar10 -poison_type none
python create_poisoned_set.py -dataset cifar10 -poison_type badnet -poison_rate 0.003
python create_poisoned_set.py -dataset cifar10 -poison_type blend -poison_rate 0.003
python create_poisoned_set.py -dataset cifar10 -poison_type trojan -poison_rate 0.003
python create_poisoned_set.py -dataset cifar10 -poison_type clean_label -poison_rate 0.003
python create_poisoned_set.py -dataset cifar10 -poison_type SIG -poison_rate 0.02
python create_poisoned_set.py -dataset cifar10 -poison_type dynamic -poison_rate 0.003
python create_poisoned_set.py -dataset cifar10 -poison_type ISSBA -poison_rate 0.02
python create_poisoned_set.py -dataset cifar10 -poison_type WaNet -poison_rate 0.05 -cover_rate 0.1
python other_attack.py -dataset cifar10 -poison_type bpp
python finetune_on_poisoned_set.py -dataset cifar10 -poison_type blend
python other_attack.py -dataset cifar10 -poison_type trojannn
python other_attack.py -dataset cifar10 -poison_type SRA

# GTSRB
python create_poisoned_set.py -dataset gtsrb -poison_type none
python create_poisoned_set.py -dataset gtsrb -poison_type badnet -poison_rate 0.01
python create_poisoned_set.py -dataset gtsrb -poison_type blend -poison_rate 0.01
python create_poisoned_set.py -dataset gtsrb -poison_type trojan -poison_rate 0.01
python create_poisoned_set.py -dataset gtsrb -poison_type dynamic -poison_rate 0.003
python create_poisoned_set.py -dataset gtsrb -poison_type WaNet -poison_rate 0.1 -cover_rate 0.2
python finetune_on_poisoned_set.py -dataset cifar10 -poison_type blend
python other_attack.py -dataset cifar10 -poison_type trojannn

# ImageNet
python create_poisoned_set.py -dataset imagenet -poison_type none
python create_poisoned_set.py -dataset imagenet -poison_type badnet -poison_rate 0.01
python create_poisoned_set.py -dataset imagenet -poison_type blend -poison_rate 0.01
python other_attack.py -dataset imagenet -poison_type SRA
## For FT attack, change in `config.py` (Line 88) the architecture for ImageNet to ViT
python finetune_on_poisoned_set.py -dataset imagenet -poison_type badnet
python finetune_on_poisoned_set.py -dataset imagenet -poison_type blend
```

You can also:
- change model architectures in [config.py](config.py)
- configure BaDExpert hyperparamters in [unlearn_utils.py](unlearn_utils.py)
- configure hyperparamters of other defenses in [other_defense.py](other_defense.py)
- see more configurations in [config.py](config.py)