import os
import argparse

parser = argparse.ArgumentParser(description='Training Noisy SNN')
parser.add_argument('--seed', default=0, type=int)
parser.add_argument('--architecture', default="SResNet18", type=str, help="SResNet18|CIFAR")
parser.add_argument('--dataset', default="CIFAR10", type=str, help="CIFAR10|CIFAR100|MNIST")
parser.add_argument('--data_path', default="/DATA/PATH", type=str)
parser.add_argument('--ckpt_path', default="./checkpoint", type=str, help="checkpoint path")
parser.add_argument('--log_path', default="./log", type=str, help="log path")
parser.add_argument('--auto_aug', default=False, action='store_true')
parser.add_argument('--cutout', default=False, action='store_true')
parser.add_argument('--milestones', default=[0.3, 0.7, 0.9, 0.95], type=float, nargs='*', )
parser.add_argument('--pretrain', default=None, type=str)
parser.add_argument('--noisy_rate', default=1, type=float)
parser.add_argument('--train_batch_size', default=128, type=int)
parser.add_argument('--val_batch_size', default=128, type=int)
parser.add_argument('--init_lr', default=0.1, type=float)
parser.add_argument('--reduce_ratio', default=0.9, type=float)
parser.add_argument('--train_spike_record', default=False, action='store_true')
parser.add_argument('--save_last', default=False, action='store_true')
parser.add_argument('--use_bn', default=False, action='store_true')
parser.add_argument('--bias', default=False, action='store_true')
parser.add_argument('--train_decay', default=False, action='store_true')
parser.add_argument('--patience', default=10, type=int)
parser.add_argument('--weight_decay', default=0, type=float)
parser.add_argument('--num_epoch', default=300, type=int)
parser.add_argument('--optim_name', default='SGDM', type=str)

parser.add_argument('--act_fun_name', default='th_relu', type=str)
parser.add_argument('--device_name', default='cuda:0', type=str)

parser.add_argument('--T', default=2, type=int, help='num of time steps')
parser.add_argument('--lr_interval', default=[0.2, 0.8, 0.9], type=float, nargs='+',
                    help='a relative point for lr reduction')
parser.add_argument('--scheduler', default='COSINE')
args = parser.parse_known_args()[0]
if not os.path.exists(args.ckpt_path):
    os.mkdir(args.ckpt_path)
if not os.path.exists(args.log_path):
    os.mkdir(args.log_path)
print(args)
