prompt_examination = "\n\nYour task is to help me optimize the selection of the seed node set to achieve the influence maximization of the given network based on the following instructions. \n\nThe seed nodes are labeled with their node index in black text. You should examine them one by one and provide the answer once any case is fulfilled. For example, if case i is fulfilled, there is no need to check case i+ and just provide the answer for case i.\n\nCase 1: If there are any pair of seed node IDs are too close, please indicate where they are by telling me their common the community ID (denoted as c). Your answer should be\n\n['case 1', c]\n\nCase 2: If one community has too many nodes (with the same color) while other communities still have no seed node, you should suggest which node (denoted as n) should be removed from the seed nodes (prefer low small-degree nodes) and which community (its community ID denoted as c) should have a seed node. Your answer should be:\n\n['case 2', n, c]\n\nCase 3: The degree of seed nodes is proportional to their node size (in triangle shape). If you find any node (denoted as n) is obviously smaller than other seed nodes, please indicate which node this is. Your answer should be\n\n['case 3', n]\n\nCase 4: If you think the current seed nodes are already optimal for achieving influence maximization in this network and cannot be improved further by the above four cases, please let me know by answering:\n\n['case 4']\n\nDo NOT output any other text or explanation."
prompt_IM_communityNode = "You are an expert in network science and you will be provided with one network in the form of an image. The network is divided into different communities and the nodes in the same community are with the same color. In each community, you will find one node labeled with the community ID in white text." + prompt_examination
prompt_IM_NocommunityNode = "You are an expert in network science and will be provided with a network in the form of an image. The network is divided into different communities, and the nodes in the same community have the same color. The legend shows the correspondence of color to community ID." + prompt_examination
prompt_IM_allnode = "You are an expert in network science and you will be provided with one network in the form of an image. The network is divided into different community and the nodes in the same community are with the same color. \n\nPlease help me carefully select 3 nodes as seeds in this network to achieve influence maximization. Please consider the importance of nodes and diversity in placement. Do NOT output any other text or explanation. Just tell me the node IDs only. Your answer be only a list as\n\n[node_id, ..., node_id]"
prompt_GD = "You are an expert in network science and you will be provided with a network in the form of image. Each node is labeled with its node id in black text.\n\n Your task is to help me dismantle this network. But no hurry, let’s do it node by node. Please tell me which node to remove to most likely collapse this network, i.e., make the largest connected component as small as possible. Please just tell me that node id only and Do NOT output any other text or explanation. Your answer should be:\n node id."


def painting_custimization(graph, task):
    network_para = {}

    if graph in ['karate', 'dolphins', 'polbooks', 'lesmis']:
        network_para['Allnode_id_YN'] = True
        network_para['legend_YN'] = True
    elif graph in ['polblogs', 'facebook', 'router']:
        network_para['Allnode_id_YN'] = False
        network_para['legend_YN'] = True
    elif graph in ['sex']:
        network_para['Allnode_id_YN'] = False
        network_para['legend_YN'] = False

    if task == 'IM_S':
        network_para['legend_YN'] = False

    if task == 'GD':
        network_para['highlighted_node_YN'] = False
    elif task == 'IM' or task == 'IM_S':
        network_para['highlighted_node_YN'] = True

    if task == 'GD':
        network_para['prompt'] = prompt_GD
    elif task == 'IM':
        if network_para['legend_YN'] == False:
            network_para['prompt'] = prompt_IM_communityNode
        else:
            network_para['prompt'] = prompt_IM_NocommunityNode
    elif task == 'IM_S':
        network_para['prompt'] = prompt_IM_allnode

    # if graph == 'karate':
    #     network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
    #         network_para['figure_size'], network_para['paint_style'], network_para['inter_ratio'],  network_para['intra_ratio'] = 0.5, 25, 15, [500, 500], 'fr', 6, 1.5
    # elif graph == 'dolphins':
    #     network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
    #         network_para['figure_size'], network_para['paint_style'], network_para['inter_ratio'],  network_para['intra_ratio'] = 0.5, 20, 15, [600, 600], 'fr', 11, 1.6
    # elif graph == 'lesmis':
    #     network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
    #         network_para['figure_size'], network_para['paint_style'], network_para['inter_ratio'],  network_para['intra_ratio'] = 0.5, 20, 15, [600, 600], 'fr', 13, 2.6
    # elif graph == 'polbooks':
    #     network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
    #         network_para['figure_size'], network_para['paint_style'],  network_para['inter_ratio'],  network_para['intra_ratio'] = 0.5, 20, 15, [700, 700], 'kk', 8, 0.9
    if graph == 'karate':
        network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
            network_para['figure_size'], network_para['paint_style'], network_para['distance'],  network_para['top_ratio'], network_para['dis_threshold'] = 0.5,  25, 15, [800, 800], 'fr', 1.0, 0.1, 0.4
    elif graph == 'dolphins':
        network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
            network_para['figure_size'], network_para['paint_style'], network_para['distance'],  network_para['top_ratio'], network_para['dis_threshold'] = 0.5,   20, 13, [900, 900], 'fr', 1.0, 0.1, 0.4
    elif graph == 'lesmis':
        network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
            network_para['figure_size'], network_para['paint_style'], network_para['distance'],  network_para['top_ratio'], network_para['dis_threshold'] = 0.5,   15, 10, [900, 900], 'kk', 1.0, 0.1, 0.4
    elif graph == 'polbooks':
        network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
            network_para['figure_size'], network_para['paint_style'], network_para['distance'],  network_para['top_ratio'], network_para['dis_threshold'] = 0.5,   18, 13, [800, 900], 'fr', 1.0, 0.1, 0.4
    elif graph == 'facebook':
        network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
            network_para['figure_size'], network_para['paint_style'], network_para['distance'],  network_para['top_ratio'], network_para['dis_threshold'] = 0.15,  10, 16, [1000, 1000], 'fr', 0.4, 0.01, 0.2
    elif graph == 'router':
        network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
            network_para['figure_size'], network_para['paint_style'], network_para['distance'],  network_para['top_ratio'], network_para['dis_threshold'] = 0.3,  10, 15, [1000, 1000], 'fr', 0.3, 0.01, 0.3
    elif graph == 'sex':
        network_para['line_width'],  network_para['node_size_others'], network_para['text_size'], \
            network_para['figure_size'], network_para['paint_style'], network_para['distance'],  network_para['top_ratio'], network_para['dis_threshold'] = 0.1,  7, 13, [1000, 1000], 'fr', 0.3, 0.005, 0.18

    return network_para
