/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalRelations;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexParseException;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GrammaticalRelation
implements Comparable<GrammaticalRelation>,
Serializable {
    private static final long serialVersionUID = 892618003417550128L;
    private static final boolean DEBUG = System.getProperty("GrammaticalRelation", null) != null;
    private static final EnumMap<Language, Map<String, GrammaticalRelation>> stringsToRelations = new EnumMap(Language.class);
    public static final GrammaticalRelation GOVERNOR = new GrammaticalRelation(Language.Any, "gov", "governor", null);
    public static final GrammaticalRelation DEPENDENT = new GrammaticalRelation(Language.Any, "dep", "dependent", null);
    public static final GrammaticalRelation ROOT = new GrammaticalRelation(Language.Any, "root", "root", null);
    public static final GrammaticalRelation KILL = new GrammaticalRelation(Language.Any, "KILL", "dummy relation kill", null);
    private static Map<String, SoftReference<GrammaticalRelation>> valueOfCache = new HashMap<String, SoftReference<GrammaticalRelation>>();
    private final Language language;
    private final String shortName;
    private final String longName;
    private final GrammaticalRelation parent;
    private final List<GrammaticalRelation> children = new ArrayList<GrammaticalRelation>();
    private final Pattern sourcePattern;
    private final List<TregexPattern> targetPatterns = new ArrayList<TregexPattern>();
    private final String specific;

    public static GrammaticalRelation valueOf(String s, Collection<GrammaticalRelation> values) {
        for (GrammaticalRelation reln : values) {
            if (!reln.toString().equals(s)) continue;
            return reln;
        }
        return null;
    }

    public static GrammaticalRelation valueOf(Language language, String s) {
        GrammaticalRelation reln;
        GrammaticalRelation grammaticalRelation = reln = stringsToRelations.get((Object)language) != null ? GrammaticalRelation.valueOf(s, stringsToRelations.get((Object)language).values()) : null;
        if (reln == null) {
            reln = EnglishGrammaticalRelations.valueOf(s);
        }
        if (reln == null) {
            String specific;
            String name;
            int underscorePosition = s.indexOf(95);
            if (underscorePosition > 0) {
                name = s.substring(0, underscorePosition);
                specific = s.substring(underscorePosition + 1);
            } else {
                name = s;
                specific = null;
            }
            reln = new GrammaticalRelation(language, name, null, null, specific);
        }
        return reln;
    }

    public static GrammaticalRelation valueOf(String s) {
        GrammaticalRelation value = null;
        SoftReference<GrammaticalRelation> possiblyCachedValue = valueOfCache.get(s);
        if (possiblyCachedValue != null) {
            value = possiblyCachedValue.get();
        }
        if (value == null) {
            value = GrammaticalRelation.valueOf(Language.English, s);
            valueOfCache.put(s, new SoftReference<GrammaticalRelation>(value));
        }
        return value;
    }

    public boolean isFromString() {
        return this.longName == null;
    }

    private GrammaticalRelation(Language language, String shortName, String longName, GrammaticalRelation parent, String sourcePattern, TregexPatternCompiler tregexCompiler, String[] targetPatterns, String specificString) {
        GrammaticalRelation previous;
        this.language = language;
        this.shortName = shortName;
        this.longName = longName;
        this.parent = parent;
        this.specific = specificString;
        if (parent != null) {
            parent.addChild(this);
        }
        if (sourcePattern != null) {
            try {
                this.sourcePattern = Pattern.compile(sourcePattern);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("Bad pattern: " + sourcePattern);
            }
        } else {
            this.sourcePattern = null;
        }
        for (String pattern : targetPatterns) {
            try {
                TregexPattern p = tregexCompiler.compile(pattern);
                this.targetPatterns.add(p);
            }
            catch (TregexParseException pe) {
                throw new RuntimeException("Bad pattern: " + pattern, pe);
            }
        }
        Map<String, GrammaticalRelation> sToR = stringsToRelations.get((Object)language);
        if (sToR == null) {
            sToR = Generics.newHashMap();
            stringsToRelations.put(language, sToR);
        }
        if ((previous = sToR.put(this.toString(), this)) != null && !previous.isFromString() && !this.isFromString()) {
            throw new IllegalArgumentException("There is already a relation named " + this.toString() + '!');
        }
    }

    public GrammaticalRelation(Language language, String shortName, String longName, GrammaticalRelation parent, String sourcePattern, TregexPatternCompiler tregexCompiler, String ... targetPatterns) {
        this(language, shortName, longName, parent, sourcePattern, tregexCompiler, targetPatterns, (String)null);
    }

    public GrammaticalRelation(Language language, String shortName, String longName, GrammaticalRelation parent) {
        this(language, shortName, longName, parent, (String)null, (TregexPatternCompiler)null, StringUtils.EMPTY_STRING_ARRAY, (String)null);
    }

    public GrammaticalRelation(Language language, String shortName, String longName, GrammaticalRelation parent, String specificString) {
        this(language, shortName, longName, parent, (String)null, (TregexPatternCompiler)null, StringUtils.EMPTY_STRING_ARRAY, specificString);
    }

    private void addChild(GrammaticalRelation child) {
        this.children.add(child);
    }

    public Collection<TreeGraphNode> getRelatedNodes(TreeGraphNode t, TreeGraphNode root, HeadFinder headFinder) {
        ArraySet<TreeGraphNode> nodeList = new ArraySet<TreeGraphNode>();
        for (TregexPattern p : this.targetPatterns) {
            TregexMatcher m = p.matcher(root, headFinder);
            while (m.findAt(t)) {
                TreeGraphNode target = (TreeGraphNode)m.getNode("target");
                if (target == null) {
                    throw new AssertionError((Object)("Expression has no target: " + p));
                }
                nodeList.add(target);
                if (!DEBUG) continue;
                System.err.println("found " + this + "(" + t + "-" + t.headWordNode() + ", " + m.getNode("target") + "-" + ((TreeGraphNode)m.getNode("target")).headWordNode() + ") using pattern " + p);
                for (String nodeName : m.getNodeNames()) {
                    if (nodeName.equals("target")) continue;
                    System.err.println("  node " + nodeName + ": " + m.getNode(nodeName));
                }
            }
        }
        return nodeList;
    }

    public boolean isApplicable(Tree t) {
        return this.sourcePattern != null && t.value() != null && this.sourcePattern.matcher(t.value()).matches();
    }

    public boolean isAncestor(GrammaticalRelation gr) {
        while (gr != null) {
            if (this.equals(gr)) {
                return true;
            }
            gr = gr.parent;
        }
        return false;
    }

    public final String toString() {
        if (this.specific == null) {
            return this.shortName;
        }
        return this.shortName + '_' + this.specific;
    }

    public String toPrettyString() {
        StringBuilder buf = new StringBuilder("\n");
        this.toPrettyString(0, buf);
        return buf.toString();
    }

    private void toPrettyString(int indentLevel, StringBuilder buf) {
        for (int i = 0; i < indentLevel; ++i) {
            buf.append("  ");
        }
        buf.append(this.shortName).append(" (").append(this.longName).append("): ").append(this.targetPatterns);
        for (GrammaticalRelation child : this.children) {
            buf.append('\n');
            child.toPrettyString(indentLevel + 1, buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            new Throwable("Warning: comparing GrammaticalRelation to String").printStackTrace();
            return this.toString().equals(o);
        }
        if (!(o instanceof GrammaticalRelation)) {
            return false;
        }
        GrammaticalRelation gr = (GrammaticalRelation)o;
        return this.language == gr.language && this.shortName.equals(gr.shortName) && (this.specific == gr.specific || this.specific != null && this.specific.equals(gr.specific));
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + (this.language != null ? this.language.toString().hashCode() : 0);
        result = 29 * result + (this.shortName != null ? this.shortName.hashCode() : 0);
        result = 29 * result + (this.specific != null ? this.specific.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(GrammaticalRelation o) {
        String thisN = this.toString();
        String oN = o.toString();
        return thisN.compareTo(oN);
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getSpecific() {
        return this.specific;
    }

    protected Object readResolve() throws ObjectStreamException {
        switch (this.language) {
            case Any: {
                if (this.shortName.equals(GrammaticalRelation.GOVERNOR.shortName)) {
                    return GOVERNOR;
                }
                if (this.shortName.equals(GrammaticalRelation.DEPENDENT.shortName)) {
                    return DEPENDENT;
                }
                if (this.shortName.equals(GrammaticalRelation.ROOT.shortName)) {
                    return ROOT;
                }
                if (this.shortName.equals(GrammaticalRelation.KILL.shortName)) {
                    return KILL;
                }
                throw new RuntimeException("Unknown general relation " + this.shortName);
            }
            case English: {
                GrammaticalRelation rel = EnglishGrammaticalRelations.valueOf(this.toString());
                if (rel == null) {
                    if (this.shortName.equals("conj")) {
                        return EnglishGrammaticalRelations.getConj(this.specific);
                    }
                    if (this.shortName.equals("prep")) {
                        return EnglishGrammaticalRelations.getPrep(this.specific);
                    }
                    if (this.shortName.equals("prepc")) {
                        return EnglishGrammaticalRelations.getPrepC(this.specific);
                    }
                    return this;
                }
                return rel;
            }
            case Chinese: {
                GrammaticalRelation rel = ChineseGrammaticalRelations.valueOf(this.toString());
                if (rel == null) {
                    return this;
                }
                return rel;
            }
        }
        throw new RuntimeException("Unknown language " + (Object)((Object)this.language));
    }

    public GrammaticalRelation getParent() {
        return this.parent;
    }

    public static void main(String[] args) {
        String[] names;
        for (String name : names = new String[]{"dep", "pred", "prep_to", "rcmod"}) {
            GrammaticalRelation reln = GrammaticalRelation.valueOf(Language.English, name);
            System.out.println("Data for GrammaticalRelation loaded as valueOf(\"" + name + "\"):");
            System.out.println("\tShort name:    " + reln.getShortName());
            System.out.println("\tLong name:     " + reln.getLongName());
            System.out.println("\tSpecific name: " + reln.getSpecific());
        }
    }

    public static enum Language {
        Any,
        English,
        Chinese;

    }
}

