#!/usr/bin/env bash
set -euo pipefail

EPOCH=100
CUDA_NUM=1
SEEDS=("80" "81" "82" "83" "84" "85" "86" "87" "88" "98" "180") 
MODELS=("ae")
SIMUL="graph"

LEARNING_RATE_LIST=("1e-4")
MDIM_LIST=("4")
NUM_LAYERS_LIST=("512")

for SEED in "${SEEDS[@]}"; do
    for NUM_LAYER in "${NUM_LAYERS_LIST[@]}"; do
      for LR in "${LEARNING_RATE_LIST[@]}"; do
        for MDIM in "${MDIM_LIST[@]}"; do
          for MODEL_NAME in "${MODELS[@]}"; do
            echo "Running MODEL=${MODEL_NAME}, SEED=${SEED}, LR=${LR}, NUM_LAYER=${NUM_LAYER}, MDIM=${MDIM}"
            python3 simulation_graph.py \
              --epoch "${EPOCH}" \
              --lr "${LR}" \
              --m_dim "${MDIM}" \
              --cuda_num "${CUDA_NUM}" \
              --seed "${SEED}" \
              --model "${MODEL_NAME}" \
              --simul_type "${SIMUL}" \
              --num_layers "${NUM_LAYER}"
          done
        done
      done
    done
  done
