﻿# Implementation of the paper "Adaptive Quality-Diversity Tradeoffs for Large-Scale Batch Recommendation"

## Prerequisites

You need to have **pixi** installed on your system. You can find detailed installation instructions on the official **pixi** GitHub repository.

* **[GitHub: prefix-dev/pixi](https://github.com/prefix-dev/pixi)**

## Installation with pixi

When using pixi, all dependencies can be installed with

```bash
export PIXI_CACHE_DIR="/path/to/your/new/cache/directory"
pixi install
pixi clean cache --pypi --conda --repodata --yes
```

And the corresponding environment can be activated with

```bash
pixi shell
```

## Installation with conda

```bash
conda create -n bdivrec -y python=3.9
conda activate bdivrec
conda install -c dglteam/label/th24_cpu dgl -y
conda install -c conda-forge scikit-sparse suitesparse -y
python3 -m pip install sparseqr scikit-sparse tensorflow tensorflow_hub fastcluster "stanscofi>=2.0.1" --no-cache-dir
python3 -m pip install -r requirements.txt --no-build-isolation --no-cache-dir
python3 -m pip install -e .
python3 -m pip cache purge
conda clean -a -y
```

## Important notes

Don't do parallelization or use the same data set in parallel instances! (due to the history being stored locally)

## Data sets

### MovieLens (small)

Download the data set [here](https://grouplens.org/datasets/movielens/latest/).

### TRANSCRIPT

Download the data set [here](https://zenodo.org/records/7982976).

### PREDICT

Download the partial data set [here](https://zenodo.org/records/8087306). For the private data set, ask the authors.

### LastFM

Download the data set [here](http://millionsongdataset.com/lastfm/#getting).

### Duolingo

Download the data set [here](https://dataverse.harvard.edu/dataset.xhtml?persistentId=doi:10.7910/DVN/23ZWVI). 

## Usage

Results will be available in the results/ folder at the root of the repository.

### Known Feedback setting

Run experiments defined in configuration file config.yml in folder known\_setting/configs/

```bash
cd experiments
[pixi run] python3 -m main --config known_setting/configs/config.yml
```

### Adaptive Relevance-Diversity Tradeoff setting

Run experiments defined in configuration file config.yml in folder adaptive\_setting/configs/ (change argument "adaptive_tradeoff" from False to True)

```bash
cd experiments
[pixi run] python3 -m main --config adaptive_lambda/configs/config.yml
```
