#coding: utf-8

import numpy as np
from scipy.optimize import LinearConstraint, minimize

class IncurError(Exception):
	pass

class AdaHedgeInit(object):
	def __init__(self, lbd, d):
		self.K = 2
		self.delta = d
		self.p = np.array([1-lbd, lbd])

	def act_all_coords(self):
		eta = np.log(self.K)/float(self.delta)
		p = np.exp(-eta*(self.p-np.min(self.p)))
		p /= np.sum(p)
		return p
		
	def act(self):
		return self.act_all_coords()[1]

	def incur(self, w):
		p = self.act_all_coords()
		eta = np.log(self.K)/float(self.delta)
		w = np.array([-w, w])
		self.p += w
		m = np.min(w)-1./eta*np.log(p.T.dot(np.exp(-eta*(w-np.min(w)))))
		if (not (m != float("inf") and p.T.dot(w) >= m-np.finfo(float).eps*2)):
			raise IncurError
		self.delta += p.T.dot(w) - m

## Compute the best a posteriori lambda for comparison
def compute_best_post_lbd(recs_total, rels_total, lbd_init, recommender, u, env, K, max_iter=10):
	bounds = [(0,1)]
	jac = lambda l: -np.sum([recommender.grad_value_f(rels, u, env, K, S, lbd=l)[0] for S, rels in zip(recs_total, rels_total)])
	hess = lambda l : 0.
	fun = lambda l : -np.sum([recommender.grad_value_f(rels, u, env, K, S, lbd=l)[1] for S, rels in zip(recs_total, rels_total)])
	res = minimize(fun, lbd_init, jac=jac, hess=hess, method='trust-constr', 
		options={'disp': 1, 'maxiter': max_iter}, bounds=bounds)
	value_star = -res.fun
	lbd_star = res.x
	return lbd_star[0], value_star
