import numpy as np
import tensorflow as tf
import random
from collections import Counter
from numpy import poly1d, polyfit
from sklearn.metrics import precision_score, recall_score, f1_score, roc_auc_score


def build_eval_set(x_train, y_train, ind, p_anon):
    x_in = x_train[y_train==ind]
    x_out = x_train[y_train!=ind]
    random.shuffle(x_out)

    num_out = int(p_anon * x_in.shape[0])
    data = np.concatenate([x_in, x_out[:num_out]], axis=0)
    gt = np.ones(data.shape[0], dtype=int)
    gt[:data.shape[0] -num_out] = 0
    return data, gt

def normIt(data, m=None):
    nData = data.copy()
    if m is None:
        m = np.mean(nData, keepdims=True)
    nData = nData - m
    nData = nData/np.linalg.norm(nData, axis =1, keepdims=True)
    return nData

def dist(data):
    t = np.mean(data, axis = 0)
    d = np.linalg.norm(data-t, axis = 1)**2
    return d

def robust_poly(feats, d):
    print('robust poly-fitting')
    diff_degree = []
    full_poly_f = []
    x = np.arange(feats.shape[0])
    degree_list = np.arange(3, 6)
    for degree in degree_list:
        poly_f = poly1d(polyfit(x, sorted(d), degree))
        full_poly_f.append(poly_f)
        thres = np.max(poly_f(x))
        normal_feats = feats[d<=thres]
        abnormal_feats = feats[d>thres]
        set_normality = np.var(dist(normal_feats))/normal_feats.shape[0]
        set_anomaly = np.var(dist(abnormal_feats))/abnormal_feats.shape[0]
        diff = set_anomaly/set_normality
        diff_degree.append(diff)
    best_poly = full_poly_f[np.argmax(diff_degree)]   
    print('optimal degree: ', degree_list[np.argmax(diff_degree)])
    best_thres = np.max(best_poly(x))
    y_pred = d > best_thres 
    return y_pred