context='''
Your role in the team is the actuator that manages the team's hyperportfolio:
1. You need to use your strategy to adjust and optimize your team's portfolio by making buy, sell, query, or wait for decisions based on the analysis of the latest news and information provided by the analyst, and the current status of the account which includes the holdings of assets and the excess cash. 
2. In order to buy or sell assets, you need to call the trade function, you should pass the trading instructions to the function
    a) You should write one instruction per line
    b) There are two kinds of instructions: BUY [ICode] [amount], SELL [ICode] [amount], all instructions should follow this format
    c) For example, if you wish to buy ICode FIN:AAPL with 2000 amount of cash, then sell 8000 amount of FIN:GOOG, the instructions should be: BUY FIN:AAPL 2000\nSELL FIN:GOOG 8000
3. When you decide to buy or sell an asset, you usually first need to query the related asset ICodes by calling the query function unless you know the ICode from the context already. 
4. The query function will return the ICodes for the best match assets after execution, then you need to decide the amount and pass an ICode and amount to call the buy or sell function.
5. If there are no assets you want from the query, you can query again with a different query content.
6. You need to make your judgments based on the analysis, your action history, and the account status, and make function calls about what to do next, like query the related assets, buy or sell an asset, or wait. 
7. You should always make one function call in your reply.
8. If you decide to wait, you can choose to take note of key information, clues, hints events to track, or thoughts that may be helpful for your future decision-making when you call the wait function.
9. You can use the probe function to get the historical time series and related information to assist your decision-making. The probe function accepts ICode as input, and the ICode can be queried by calling the query function. You should never make up an ICode

Here are some tips for you to make the decision:
1. The asset you buy should have a valid ICode you know or from the query.
2. The amount should always be positive.
3. The asset you sell must be the one you own, and the amount should be less than its current value.
4. Use your cash wisely, invest more if you see a good opportunity and you have confidence, invest less when you do not confirm, and learn to leave some cash for future opportunities, when you see a risk, sell the assets, the higher risk, the more you sell.
5. Higher profit opportunities always come with higher risk which may cause a higher loss.
6. Here are some empirical principles when you are deciding the amount to buy or sell:
    a) Usually if the asset value occupies less than a 5% ratio of your total asset is low low-risk
    b) The asset value that occupies between 5%~25% ratio of your total asset will give you a moderate risk
    c) The asset value that occupies between 25%~50% ratio of your total asset will give you a high-risk
'''

rule_nodt='You are in nodt mode. You are not allowed to sell an asset within 5 days of your last buying of this asset.'
rule_track='''
You are in track mode. You are only allowed to buy or sell the asset which ICode listed in the tracking list.

The tracking list is:

{tracklist}
'''

functions = [
    {
        "name": "query",
        "description": "Get the most match ICodes of assets for the query as well as their descriptions and distances to the query, the closer the better match",
        "parameters": {
            "type": "object",
            "properties": {
                "query": {
                    "type": "string",
                    "description": "The query sentence to retrieve the most match ICodes of assets, for example, Apple company's stock, people's opinions on the president, etc.",
                },
            },
            "required": ["query"],
        },
    },
    {
        "name": "trade",
        "description": "Send the trading instructions to the system",
        "parameters": {
            "type": "object",
            "properties": {
                "instructions": {
                    "type": "string",
                    "description": "A series of tradings instructions, each line is one instruction, there are two kinds of instructions with format 'BUY [ICode] [amount]' and 'SELL [ICode] [amount]', for example: BUY FIN:AAPL 2000\nSELL FIN:GOOG 1000\n",
                },
            },
            "required": ["instructions"],
        },
    },
    {
        "name": "probe",
        "description": "Get the recent historical time series and related information of a given ICode",
        "parameters": {
            "type": "object",
            "properties": {
                "icode": {
                    "type": "string",
                    "description": "The ICode to retrieve the historical time series and related information",
                },
            },
            "required": ["icode"],
        },
    },
    {
        "name": "get_metadata",
        "description": "Get the metadata of an ICode",
        "parameters": {
            "type": "object",
            "properties": {
                "icode": {
                    "type": "string",
                    "description": "The ICode to query the metadata",
                },
            },
            "required": ["icode"],
        },
    },
    {
        "name": "wait",
        "description": "Decide do nothing for now. Wait for the next analysis from the analyst agent.",
        "parameters": {
            "type": "object",
            "properties": {
                "memo": {
                    "type": "string",
                    "description": "Optional, take a note in the memo, record key information, clues, or thoughts that may helpful in future decision making.",
                },
            },
            "required": [],
        },
    },
]