WEKA_CLUSTERS = ",".join(
    # ["jupiter-cirrascale-2", "ceres-cirrascale"]
    ["jupiter-cirrascale-2", "saturn-cirrascale", "ceres-cirrascale"]
    # ["jupiter-cirrascale-2", "saturn-cirrascale", "ceres-cirrascale", "neptune-cirrascale"]
)
GCP_CLUSTERS = ",".join(
    ["augusta-google-1"]
)
# "neptune-cirrascale", # L40s, can't load 70B+

# Varying the model size
MODEL_LADDER_LIST = [
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step81352-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-190M-0.5xC/step3641-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-190M-10xC/step72625-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-190M-2xC/step14533-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-190M-5xC/step36318-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-0.5xC/step8145-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-10xC/step162000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-2xC/step32547-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-370M-0.5xC/step4731-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-370M-10xC/step94427-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-370M-2xC/step18894-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-370M-5xC/step47219-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-3B-0.5xC/step10086-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-3B-10xC/step201524-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-3B-2xC/step40313-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-3B-5xC/step100767-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-760M-0.5xC/step5795-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-760M-10xC/step115706-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-760M-2xC/step23150-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-760M-5xC/step57858-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-rerun-190M-1xC/step7272-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-rerun-1B-1xC/step16279-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-rerun-370M-1xC/step9452-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-rerun-3B-1xC/step20162-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-rerun-760M-1xC/step11580-unsharded-hf",
    "ANON/checkpoints/OLMo-medium/peteish7/step928646-hf-vllm-2", # converted to new vllm format
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step476848-hf-vllm",
]

# Varying the checkpoint at 1B 5xC (data mix is olmoe)
MODEL_LIST_INTERMEDIATE = [
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step0-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step1000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step1500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step2000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step2500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step3000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step3500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step4000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step4500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step5000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step5500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step6000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step6500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step7000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step7500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step8000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step8500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step9000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step9500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step10000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step10500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step11000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step11500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step12000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step12500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step13000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step13500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step14000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step14500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step15000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step15500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step16000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step16500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step17000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step17500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step18000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step18500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step19000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step19500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step20000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step20500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step21000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step21500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step22000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step22500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step23000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step23500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step24000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step24500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step25000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step25500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step26000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step26500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step27000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step27500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step28000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step28500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step29000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step29500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step30000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step30500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step31000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step31500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step32000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step32500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step33000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step33500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step34000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step34500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step35000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step35500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step36000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step36500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step37000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step37500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step38000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step38500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step39000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step39500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step40000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step40500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step41000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step41500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step42000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step42500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step43000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step43500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step44000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step44500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step45000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step45500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step46000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step46500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step47000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step47500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step48000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step48500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step49000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step49500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step50000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step50500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step51000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step51500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step52000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step52500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step53000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step53500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step54000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step54500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step55000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step55500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step56000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step56500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step57000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step57500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step58000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step58500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step59000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step59500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step60000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step60500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step61000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step61500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step62000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step62500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step63000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step63500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step64000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step64500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step65000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step65500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step66000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step66500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step67000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step67500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step68000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step68500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step69000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step69500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step70000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step70500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step71000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step71500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step72000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step72500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step73000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step73500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step74000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step74500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step75000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step75500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step76000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step76500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step77000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step77500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step78000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step78500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step79000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step79500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step80000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step80500-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step81000-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/peteish-moreeval-1B-5xC/step81352-unsharded-hf",
]

# Smaller list of 85 intermediate checkpoints (every 1K steps instead of every 500 steps)
MODEL_LIST_INTERMEDIATE_SMALL = [model for model in MODEL_LIST_INTERMEDIATE if '500-unsharded' not in model]

MODEL_LIST_INTERMEDIATE_13B = [
    # from weka
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step0",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step4000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step8000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step12000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step16000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step20000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step24000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step28000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step32000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step36000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step40000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step44000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step48000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step52000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step56000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step60000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step64000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step68000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step72000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step76000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step80000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step84000",

    # from aws
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step88000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step92000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step96000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step100000",

    # from hf
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step104000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step108000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step112000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step116000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step120000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step124000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step128000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step132000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step136000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step140000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step144000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step148000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step152000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step156000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step160000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step164000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step168000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step172000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step176000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step180000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step184000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step188000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step192000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step196000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step200000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step204000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step208000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step212000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step216000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step220000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step224000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step228000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step232000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step236000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step240000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step244000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step248000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step252000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step256000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step260000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step264000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step268000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step272000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step276000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step280000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step284000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step288000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step292000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step296000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step300000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step304000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step308000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step312000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step316000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step320000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step324000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step328000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step332000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step336000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step340000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step344000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step348000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step352000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step356000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step360000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step364000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step368000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step372000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step376000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step380000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step384000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step388000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step392000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step396000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step400000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step404000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step408000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step412000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step416000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step420000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step424000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step428000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step432000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step436000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step440000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step444000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step448000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step452000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step456000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step460000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step464000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step468000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step472000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step476000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step480000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step484000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step488000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step492000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step496000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step500000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step504000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step508000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step512000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step516000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step520000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step524000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step528000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step532000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step536000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step540000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step544000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step548000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step552000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step556000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step560000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step564000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step568000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step572000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step576000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step580000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step584000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step588000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step592000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step596057"
]

MODEL_LIST_INTERMEDIATE_7B = [
    'ANON/checkpoints/OLMo-medium/peteish7/step900000',
    'ANON/checkpoints/OLMo-medium/peteish7/step901000',
    'ANON/checkpoints/OLMo-medium/peteish7/step902000',
    'ANON/checkpoints/OLMo-medium/peteish7/step903000',
    'ANON/checkpoints/OLMo-medium/peteish7/step904000',
    'ANON/checkpoints/OLMo-medium/peteish7/step905000',
    'ANON/checkpoints/OLMo-medium/peteish7/step906000',
    'ANON/checkpoints/OLMo-medium/peteish7/step907000',
    'ANON/checkpoints/OLMo-medium/peteish7/step908000',
    'ANON/checkpoints/OLMo-medium/peteish7/step909000',
    'ANON/checkpoints/OLMo-medium/peteish7/step910000',
    'ANON/checkpoints/OLMo-medium/peteish7/step911000',
    'ANON/checkpoints/OLMo-medium/peteish7/step912000',
    'ANON/checkpoints/OLMo-medium/peteish7/step913000',
    'ANON/checkpoints/OLMo-medium/peteish7/step914000',
    'ANON/checkpoints/OLMo-medium/peteish7/step915000',
    'ANON/checkpoints/OLMo-medium/peteish7/step916000',
    'ANON/checkpoints/OLMo-medium/peteish7/step917000',
    'ANON/checkpoints/OLMo-medium/peteish7/step918000',
    'ANON/checkpoints/OLMo-medium/peteish7/step919000',
    'ANON/checkpoints/OLMo-medium/peteish7/step920000',
    'ANON/checkpoints/OLMo-medium/peteish7/step921000',
    'ANON/checkpoints/OLMo-medium/peteish7/step922000',
    'ANON/checkpoints/OLMo-medium/peteish7/step923000',
    'ANON/checkpoints/OLMo-medium/peteish7/step924000',
    'ANON/checkpoints/OLMo-medium/peteish7/step925000',
    'ANON/checkpoints/OLMo-medium/peteish7/step926000',
    'ANON/checkpoints/OLMo-medium/peteish7/step927000',
    'ANON/checkpoints/OLMo-medium/peteish7/step928000',
    'ANON/checkpoints/OLMo-medium/peteish7/step928646',
]

MODEL_LIST_FINAL_30_13B = [
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step567000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step568000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step569000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step570000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step571000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step572000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step573000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step574000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step575000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step576000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step577000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step578000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step579000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step580000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step581000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step582000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step583000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step584000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step585000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step586000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step587000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step588000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step589000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step590000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step591000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step592000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step593000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step594000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step595000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step596000",
    "ANON/checkpoints/OLMo-medium/peteish13-highlr/step596057"
]

MODEL_LIST_FINAL_30_1B = [
    "ANON/checkpoints/OLMo-small/peteish1/step1610000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1620000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1630000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1640000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1650000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1660000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1670000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1680000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1690000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1700000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1710000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1720000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1730000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1740000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1750000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1760000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1770000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1780000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1790000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1800000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1810000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1820000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1830000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1840000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1850000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1860000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1870000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1880000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1890000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1900000-unsharded-hf",
    "ANON/checkpoints/OLMo-small/peteish1/step1907359-unsharded-hf",
]

MODEL_LIST_INTERMEDIATE_32B = [
    "ANON/checkpoints/OLMo-large/peteish32/step693000",
    "ANON/checkpoints/OLMo-large/peteish32/step694000",
    "ANON/checkpoints/OLMo-large/peteish32/step695000",
    "ANON/checkpoints/OLMo-large/peteish32/step696000",
    "ANON/checkpoints/OLMo-large/peteish32/step697000",
    "ANON/checkpoints/OLMo-large/peteish32/step698000",
    "ANON/checkpoints/OLMo-large/peteish32/step699000",
    "ANON/checkpoints/OLMo-large/peteish32/step700000",
    "ANON/checkpoints/OLMo-large/peteish32/step701000",
    "ANON/checkpoints/OLMo-large/peteish32/step702000",
    "ANON/checkpoints/OLMo-large/peteish32/step703000",
    "ANON/checkpoints/OLMo-large/peteish32/step704000",
    "ANON/checkpoints/OLMo-large/peteish32/step705000",
    "ANON/checkpoints/OLMo-large/peteish32/step706000",
    "ANON/checkpoints/OLMo-large/peteish32/step707000",
    "ANON/checkpoints/OLMo-large/peteish32/step708000",
    "ANON/checkpoints/OLMo-large/peteish32/step709000",
    "ANON/checkpoints/OLMo-large/peteish32/step710000",
    "ANON/checkpoints/OLMo-large/peteish32/step711000",
    "ANON/checkpoints/OLMo-large/peteish32/step712000",
    "ANON/checkpoints/OLMo-large/peteish32/step713000",
    "ANON/checkpoints/OLMo-large/peteish32/step714000",
    "ANON/checkpoints/OLMo-large/peteish32/step715000",
    "ANON/checkpoints/OLMo-large/peteish32/step716000",
    "ANON/checkpoints/OLMo-large/peteish32/step717000",
    "ANON/checkpoints/OLMo-large/peteish32/step718000",
    "ANON/checkpoints/OLMo-large/peteish32/step719000",
    "ANON/checkpoints/OLMo-large/peteish32/step720000",
    "ANON/checkpoints/OLMo-large/peteish32/step721000",
    "ANON/checkpoints/OLMo-large/peteish32/step721901",
]

MODEL_LIST_SEED_RUNS = [
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-2435-high-eval-interval-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-1029-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-data-seed-01345-1B-5xC/step75000-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-data-seed-10294-1B-5xC/step17250-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-data-seed-23095-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-data-seed-39240-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-data-seed-59430-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-data-seed-60439-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/seed/OLMo2-data-seed-89632-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-data-seed-28530-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-data-seed-40593-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-data-seed-59602-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-1029-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-1304-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-2435-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-3004-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-3043-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-4921-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-4932-1B-5xC/step51250-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-5093-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-5730-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-5794-1B-5xC/step81342-hf",
    "ANON/checkpoints/ANON/ladder/checkpoints/OLMo2-9258-1B-5xC/step81342-hf",
]

# (Old, see next list) Varying the data mix at 1B 5xC for 20 models
MODEL_LIST_MIXES = [
    "ANON/checkpoints/OLMo-ladder/ANON/baseline-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/c4-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/no_code-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/no_flan-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/no_reddit-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/redpajama-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-1B-5xC",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-1B-5xC",
]

# Varying the data mix at 1B 5xC for all 25 models in DDOS suite
MODEL_LIST_MIXES_FINAL = [
    'ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/c4-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-150M-5xC/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/baseline-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_code-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_flan-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_reddit-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-150M-5xC/step38167-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-150M-5xC/step38167-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-150M-5xC-2/step38157-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/c4-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-1B-5xC/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-1B-5xC/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/baseline-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_code-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_flan-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_reddit-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-1B-5xC/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-1B-5xC/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-1B-5xC-2/step69369-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/c4-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-300M-5xC/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/baseline-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_code-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_flan-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-300M-5xC-2/step40000-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_reddit-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-300M-5xC/step45797-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-300M-5xC/step45797-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-300M-5xC-2/step45787-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/c4-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-530M-5xC/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/baseline-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_code-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_flan-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_reddit-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-530M-5xC/step57786-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-530M-5xC/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-530M-5xC-2/step57776-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/c4-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-750M-5xC/step62500-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_code-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_flan-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/no_reddit-750M-5xC-2/step63589-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-750M-5xC/step63599-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-750M-5xC/step63599-unsharded-hf',
    'ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-750M-5xC-2/step63589-unsharded-hf'
]
MODEL_LIST_MIXES_FINAL_EXTENDED = [
    "ANON/checkpoints/OLMo-ladder/ANON/c4-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/c4-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/c4-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/c4-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-4M-5xC/step5745-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/DCLM-baseline-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw2-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_ft7percentile_fw3-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top10-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dclm_fw_top3-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-25p-DCLM-baseline-75p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-50p-DCLM-baseline-50p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-75p-DCLM-baseline-25p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma17-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/dolma-v1-6-and-sources-baseline-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top10p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_eli5_oh_top20p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_og_eli5_oh_top10p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/falcon_and_cc_tulu_qc_top10-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/fineweb_edu_dedup-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_code-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_code-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_code-60M-5xC/step29062-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_code-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_flan-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_flan-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_flan-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_flan-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_math_no_code-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_reddit-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_reddit-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_reddit-60M-5xC/step29052-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/no_reddit-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-4M-5xC/step5725-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top10p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-20M-5xC/step14594-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-60M-5xC/step29062-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/pos_eli5_oh_neg_dclm_refinedweb_steps_2000_lr3e4_top20p-90M-5xC/step29901-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-4M-5xC/step5735-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-20M-5xC/step14584-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-60M-5xC/step29042-unsharded-hf",
    "ANON/checkpoints/OLMo-ladder/ANON/prox_fineweb_pro-90M-5xC/step29901-unsharded-hf",
]
DDOS_MODEL_NAMES = \
    sorted([model.split('ANON/')[1].split('/step')[0] for model in MODEL_LIST_MIXES_FINAL]) + \
    sorted([model.split('ANON/')[1].split('/step')[0] for model in MODEL_LIST_MIXES_FINAL_EXTENDED])

OE_EVAL_BASE_MODELS = [
    # Base Models
    "deepseek-7b",
    "falcon-7b",
    "gemma-2b",
    "gemma-7b",
    "gemma2-2b",
    "gemma2-9b",
    "llama2-7b",
    "llama2-13b",
    "llama3-8b",
    "llama3.1-8b",
    "llama3.2-1b",
    "llama3.2-3b",
    "llama3-70b",
    "llama3.1-70b",
    "mistral-7b-v0.1",
    "mistral-7b-v0.3",
    "mpt-7b",
    "neo-7b",
    "olmo-1b",
    "olmo-1b-0724",
    "olmo-7b",
    "olmo-7b-0424",
    "olmo-7b-0724",
    "olmoe-1b-7b-0924",
    "phi-1.5",
    "pythia-160m",
    "pythia-1b",
    "pythia-6.9b",
    "qwen2-1.5b",
    "qwen2-7b",
    "qwen2.5-3b",
    "qwen2.5-7b",
    "qwen2.5-14b",
    "qwen2.5-32b",
    "qwen2.5-72b",
]

OE_EVAL_BASE_MODELS_EXTENDED = [
    "1.5-Pints-16K-v0.1",
    "1.5-Pints-2K-v0.1",
    "AMD-Llama-135m",
    "aya-expanse-8b",
    "Bielik-11B-v2",
    "btlm-7b-base-v0.2",
    "CantoneseLLMChat-v0.5",
    "codegemma-1.1-2b",
    "Codestral-22B-v0.1",
    "DeciLM-7B",
    "deepseek-llm-7b-base",
    "deepseek-moe-16b-base",
    "dictalm2.0",
    "dolly-v1-6b",
    "falcon-11B",
    "falcon-7b",
    "falcon-mamba-7b",
    "Falcon3-10B-Base",
    "Falcon3-2x10B-MoE-Instruct",
    "Falcon3-3B-Base",
    "Falcon3-7B-Base",
    "Falcon3-Mamba-7B-Base",
    "fietje-2",
    "Fox-1-1.6B",
    "gemma-mling-7b",
    "gpt-j-6b",
    "gpt-neox-20b",
    "gpt-sw3-40b",
    "granite-3.0-1b-a400m-base",
    "granite-3.0-2b-base",
    "granite-3.0-3b-a800m-base",
    "granite-3.0-8b-base",
    "granite-3.1-1b-a400m-base",
    "granite-3.1-2b-base",
    "granite-3.1-8b-base",
    "granite-7b-base",
    "h2o-danube3-4b-base",
    "Hebrew-Mistral-7B-200K",
    "HelpingAI-15B",
    "HelpingAI-3B-reloaded",
    "HelpingAI2-9B",
    "HelpingAI2.5-10B",
    "InstructLM-500M",
    "INTELLECT-1",
    "internlm2_5-20b-llamafied",
    "internlm2-1_8b",
    "llama-160m",
    "Llama-3-6.3b-v0.1",
    "llama-43m-beta",
    "llama-68m",
    "Loxa-4B",
    "Lucie-7B",
    "magistrate-3.2-3b-base",
    "Minitron-4B-Base",
    "Minitron-8B-Base",
    "Mistral-7B-v0.2",
    "Mistral-Nemo-Base-2407",
    "Mistral-Nemo-Kurdish",
    "Mistral-NeMo-Minitron-Upscale-v1",
    "Mistral-NeMo-Minitron-Upscale-v2",
    "Mistral-NeMo-Minitron-Upscale-v3",
    "Mistral-Small-24B-Base-2501",
    "Mistral-v0.3-6B",
    "MN-Slush",
    "MobileLLM-125M-HF",
    "Nemotron-4-Mini-Hindi-4B-Base",
    "Nemotron-4-Mini-Hindi-4B-Instruct",
    "Nemotron-Mini-4B-Instruct",
    "NEPALI-LLM",
    "OLMo-7B-hf",
    "OLMoE-1B-7B-0924",
    "opt-1.3b",
    "phi-1_5",
    "phi-1",
    "phi-2",
    "phi-4",
    "PowerLM-3b",
    "Priya-10B",
    "Priya-3B",
    "pruned10-llama-3.2-3B",
    "pruned20-llama-3.2-3b",
    "pruned40-llama-1b",
    "pruned40-llama-3.2-3b",
    "pruned60-llama-1b",
    "pruned60-llama-3.2-3b",
    "PULI-GPTrio",
    "PULI-LlumiX-32K",
    "pythia-1.4b",
    "pythia-12b",
    "pythia-160m",
    "pythia-1b",
    "pythia-2.8b",
    "pythia-410m",
    "Qwarkstar-4B",
    "Qwen1.5-0.5B",
    "Qwen1.5-1.8B",
    "Qwen1.5-14B",
    "Qwen1.5-4B",
    "Qwen1.5-7B",
    "Qwen1.5-MoE-A2.7B",
    "Qwen2-0.5B",
    "Qwen2-1.5B",
    "Qwen2.5-0.5B",
    "Qwen2.5-1.5B",
    "Qwen2.5-3B",
    "Qwen2.5-4B",
    "Qwen2.5-Coder-14B",
    "Qwen2.5-Coder-7B",
    "Qwen2.5-Math-7B",
    "RedPajama-INCITE-7B-Base",
    "RedPajama-INCITE-Base-3B-v1",
    "RYS-Medium",
    "RYS-Phi-3-medium-4k-instruct",
    "salamandra-7b-instruct",
    "salamandra-7b",
    "Sheared-LLaMA-1.3B",
    "Sheared-LLaMA-2.7B",
    "smol_llama-220M-GQA-fineweb_edu",
    "smol_llama-220M-GQA",
    "SmolLM-1.7B",
    "SmolLM-135M",
    "SmolLM-360M",
    "SmolLM2-1.7B",
    "SmolLM2-135M",
    "SmolLM2-360M",
    "SOLAR-10.7B-v1.0",
    "stablelm-2-1_6b",
    "stablelm-3b-4e1t",
    "starcoder2-3b",
    "starcoder2-7b",
    "Superthoughts-lite-1.8B-experimental-o1",
    "TinyLlama_v1.1",
    "TinyLlama-1.1B-intermediate-step-1431k-3T",
    "TinyMistral-248M-v2.5",
    "TinyMistral-248M-v3",
    "TinyYi-7B-Test",
    "WindyFloLLM",
    "Yarn-Llama-2-13b-128k",
    "Yarn-Llama-2-7b-128k",
    "Yarn-Llama-2-7b-64k",
    "Yarn-Mistral-7b-128k",
    "Yarn-Mistral-7b-64k",
    "Yarn-Solar-10b-32k",
    "Yarn-Solar-10b-64k",
    "Yi-1.5-6B",
    "Yi-1.5-9B-32K",
    "Yi-1.5-9B",
    "Yi-6B-200K",
    "Yi-6B",
    "Yi-9B-200K",
    "Yi-9B",
]

OE_EVAL_BASE_MODELS_EXTENDED_2 = [
    "deepseek-llm-7b-base",
    "deepseek-llm-67b-base",
    "qwen2-72b",
    "qwen1.5-110b",
    "qwen1.5-72b",
    "qwen1.5-32b",
    "qwen1.5-0.5b",
    "codeqwen1.5-7b",
    "mixtral-8x7b-v0.1",
    "mixtral-8x22b-v0.1",
    "mistral-7b-v0.1",
    "mistral-7b-v0.3",
    "codestral-22b-v0.1",
    "mathstral-7b-v0.1",
    "mistral-nemo-base-2407",
    "mistral-small-24b-base-2501",
    "mistral-small-3.1-24b-base-2503",
    "yi-34b",
    "yi-1.5-34b",
    "smollm2-360m",
    "gemma-2-2b",
    "gemma-2-9b",
    "gemma-2-27b",
    "gemma-2b",
    "gemma-7b",
    "orca-2-7b",
    "orca-2-13b",
    "pythia-14m",
    "pythia-70m",
    "pythia-410m",
    "llama-7b",
    "llama-13b",
    "llama-30b",
    "llama-65b",
    "llama-3.1-8b",
    "llama-3.1-70b",
    "olmo-7b-twin-2t-hf",
    "olmo-2-0325-32b",
    "olmo-2-1124-13b",
    "olmo-2-1124-7b",
]

OE_EVAL_INSTRUCT_MODELS = [
    "gemma2-2b-instruct",
    "gemma2-9b-instruct",
    "gemma2-9b-instruct-SimPO",
    "llama3.2-1b-instruct",
    "llama3.2-3b-instruct",
    "llama3-8b-instruct",
    "llama3.1-8b-instruct",
    "llama-3.1-tulu-2-8b",
    "llama-3.1-tulu-2-dpo-8b",
    "llama3.1-70b-instruct",
    "olmo-7b-0724-instruct",
    "olmoe-1b-7b-0924-instruct",
    "qwen2.5-7b-instruct",
    "qwen2.5-14b-instruct",
    "zamba2-7b",
    "zamba2-7b-instruct",
    "ministral-8b-instruct-2410",
]

OE_EVAL_ALL_MODELS = OE_EVAL_BASE_MODELS + OE_EVAL_INSTRUCT_MODELS + OE_EVAL_BASE_MODELS_EXTENDED + OE_EVAL_BASE_MODELS_EXTENDED_2