#!/bin/bash

CKPT=${1%/}  # e.g., magicdrive-log/SDv1.5mv-rawbox_2023-07-29_09-44_0.2.0+run10e150

TAG_SUBFIX=${TAG_SUBFIX:-""}

readarray -d _ -t TAG < <(printf '%s' "${CKPT}")
TAG="${TAG[-1]}${TAG_SUBFIX}"
echo Run for ${TAG}

set -x
set -e

python tools/fid_score.py cfg \
    resume_from_checkpoint=${CKPT} task_id=${TAG}_full \
    fid.rootb=tmp/cvt${TAG}/${TAG}
 