from pathlib import Path
import matplotlib.pyplot as plt
import requests
from tqdm import tqdm

plt.rcParams.update({'font.size': 22})

ROOT = Path(__file__).parent
NEGATIVE_COLOR = "#a86d32"
POSITIVE_COLOR = "#323ea8"
NEUTRAL_COLOR = '#9aa19c'

DB_PATH = ROOT / "gen_review.db"
if not DB_PATH.exists():
    print("Downloading Gen-Review dataset from Harvard Dataverse...")
    url = "https://dataverse.harvard.edu/api/access/datafile/11410107"
    with requests.get(url, stream=True) as r:
        r.raise_for_status()
        total_size = int(r.headers.get('content-length', 0))
        chunk_size = 8192
        with open(str(DB_PATH), "wb") as f, tqdm(total=total_size, unit='B', unit_scale=True,
                                                 desc=str(DB_PATH)) as pbar:
            for chunk in r.iter_content(chunk_size=chunk_size):
                if chunk:
                    f.write(chunk)
                    pbar.update(len(chunk))
