"""
Plot the number of suspicious reviews on all the editions of ICLR between 2018 and 2025.
"""
from binoculars.detector import BINOCULARS_FPR_THRESHOLD
import sqlite3
import matplotlib.pyplot as plt
from config import DB_PATH


def get_anomalous_human_reviews():
    get_anomalies_query = """
        select when_submitted, count(*)
        from review join submission on review.paper_id=submission.id
        where binocular_score < ?
        group by when_submitted
        order by when_submitted
    """

    get_review_count_per_year = """
        select when_submitted, count(*)
        from review join submission on review.paper_id=submission.id
        group by when_submitted
        order by when_submitted
    """

    with sqlite3.connect(str(DB_PATH)) as connection:
        results = connection.execute(get_anomalies_query, [BINOCULARS_FPR_THRESHOLD]).fetchall()
        review_count = connection.execute(get_review_count_per_year).fetchall()

    anomalies_dict = {k: 0 for k in range(2018, 2026)}
    for r in results:
        anomalies_dict.update({r[0]: r[1]})
    return anomalies_dict


if __name__ == '__main__':
    anomalies_dict = get_anomalous_human_reviews()
    plt.plot(anomalies_dict.keys(), anomalies_dict.values())
    plt.xticks(rotation=45)
    plt.xlabel("Year")
    plt.ylabel("Anomalies")
    plt.tight_layout()
    plt.show()
