import matplotlib.pyplot as plt
import numpy as np

from config import POSITIVE_COLOR, NEGATIVE_COLOR
from dataset_metrics.accept_reject_agreement import get_accept_reject_agreement
from dataset_metrics.genai_reviewers_agreement import get_review_agreement

agreement_per_year, disagreement_per_year = get_review_agreement()
accept_agreement, reject_agreement = get_accept_reject_agreement()
years = list(range(2018, 2026))
x = np.arange(len(years))
x_decision = np.array([0,1])
width = 0.2
n_columns = 2

fig1, ax1 = plt.subplots()
ax1.bar(x, [agreement_per_year[k] for k in years], width=width, label='Agree', color=POSITIVE_COLOR)
ax1.bar(x + width, [disagreement_per_year[k] for k in years], width=width, label='Disagree', color=NEGATIVE_COLOR)
ax1.set_xticks(x + width * (n_columns - 1) / 2, [str(y) for y in years], rotation=45)
ax1.legend()

# Plot 2: Main Review
fig2, ax2 = plt.subplots()
ax2.barh(x_decision + width / 2, [accept_agreement['agree'], reject_agreement['agree']], height=width, label='Agree',
         color=POSITIVE_COLOR)
ax2.barh(x_decision - width / 2, [accept_agreement['disagree'], reject_agreement['disagree']], height=width,
         label='Disagree', color=NEGATIVE_COLOR)
ax2.set_yticks(x_decision, ['Accept', 'Reject'])
ax2.set_xscale('log')
ax2.legend()

fig1.tight_layout()
fig2.tight_layout()
plt.show()