import numpy as np

from dataset_metrics.anomalies_per_year import get_anomalous_human_reviews
from dataset_metrics.scores_shift import get_scores_human_ai
import matplotlib.pyplot as plt
from binoculars.detector import BINOCULARS_FPR_THRESHOLD

scores_human, scores_ai = get_scores_human_ai()
anomalies_dict = get_anomalous_human_reviews()

fig1, ax1 = plt.subplots()
counts, bins = np.histogram(scores_human, bins=100, density=True)
ax1.stairs(counts, bins, label='Human')
ax1.bar(bins[:-1], counts, width=np.diff(bins), align='edge', alpha=0.2, color='blue')

counts, bins = np.histogram(scores_ai, bins=100, density=True)
ax1.stairs(counts, bins, label='GenAI')
ax1.bar(bins[:-1], counts, width=np.diff(bins), align='edge', alpha=0.2, color='orange')

ax1.axvline(x=BINOCULARS_FPR_THRESHOLD, color='red', linestyle='--', label="threshold")
ax1.set_xlabel("Binocular score")
ax1.set_ylabel("Density")
ax1.legend()
fig1.tight_layout()

# Plot 2: Main Review
fig2, ax2 = plt.subplots()
ax2.plot(anomalies_dict.keys(), anomalies_dict.values())
ax2.set_xlabel("Year")
ax2.set_ylabel("Anomalies")
fig2.tight_layout()

print(anomalies_dict)

plt.show()
