import numpy as np

__all__=["l1_error_calculator"]
def l1_error_calculator(target, target_hat, is_percentage=True):
    r"""
    input:
        target: e.g. true transition matrix
        target_hat: e.g. estimated transition matrix
    """
    target = np.array(target).flatten()
    target_hat = np.array(target_hat).flatten() 
    if is_percentage:
        return np.linalg.norm((target_hat-target), ord=1)/np.linalg.norm(target, ord=1)
    else:
        return np.linalg.norm((target_hat-target), ord=1)


# t=[[7.08084597e-01,1.35076536e-02,6.30357169e-02,8.25467721e-03,2.10119056e-02,2.17623308e-02,1.05059528e-02,3.75212601e-02,5.10289137e-02,6.52869925e-02],[8.50150420e-02,4.95772855e-01,9.18553327e-02,9.38097015e-02,8.40378576e-02,1.27033971e-02,8.79465951e-03,6.84029073e-03,6.15626166e-02,5.96082478e-02],[5.33749148e-06,1.38289552e-05,9.99919938e-01,2.42613249e-07,0.00000000e+00,1.45567949e-05,1.96516732e-05,1.94090599e-06,2.13499659e-05,3.15397224e-06],[2.36827182e-02,3.62799087e-02,1.51166286e-02,7.88367199e-01,3.57760211e-02,1.51166286e-03,3.52721335e-02,1.05816400e-02,2.46904934e-02,2.87215944e-02],[7.46216394e-04,1.69142383e-02,5.96973115e-03,1.06957683e-02,8.97270876e-01,1.89041486e-02,6.46720875e-03,1.29344175e-02,1.98991038e-02,1.01982907e-02],[1.12293122e-02,2.05414247e-03,8.76434120e-03,9.31211252e-03,3.42357078e-03,9.35362984e-01,1.34203975e-02,1.19140263e-02,9.58599819e-04,3.56051361e-03],[9.31301057e-03,8.19544930e-03,3.35268380e-03,2.49588683e-02,8.56796972e-03,1.00580514e-02,8.69617852e-01,1.37832556e-02,2.12336641e-02,3.09191951e-02],[3.37938064e-02,7.11448556e-03,2.84579422e-02,3.02365636e-02,8.89310695e-03,2.04541460e-02,1.33396604e-02,7.58107491e-01,7.73700304e-02,2.22327674e-02],[3.63155497e-02,4.70567686e-02,3.78500095e-02,3.17121701e-02,2.35283843e-02,1.63675717e-02,4.50108221e-02,1.17641921e-02,7.22262768e-01,2.81317638e-02],[5.63589917e-02,6.67637287e-02,2.60118423e-03,0.00000000e+00,6.67637287e-02,5.20236847e-03,4.50871934e-02,7.37002199e-02,6.06942988e-02,6.22828286e-01]]
# tb=[[9.13994014e-01,3.24022770e-03,1.24779502e-02,1.43500266e-03,6.09614654e-03,5.53312432e-03,1.06749765e-03,2.32561622e-02,1.66881010e-02,1.62116941e-02],[1.44098429e-02,7.82398999e-01,5.06599657e-02,6.51623607e-02,4.54157814e-02,5.02646202e-03,6.43835170e-04,1.61236571e-03,1.78794377e-02,1.67909637e-02],[8.01709366e-10,1.27680044e-09,1.00000000e+00,1.52013069e-08,6.61759225e-09,1.22500099e-08,8.85759732e-09,3.22274651e-09,3.91033783e-09,5.98057204e-09],[3.53447598e-04,6.72050402e-04,2.76328926e-03,9.86163914e-01,1.03062810e-03,1.02923624e-03,1.80315087e-03,1.51394890e-03,2.27671443e-03,2.39363941e-03],[1.58058738e-05,1.18547620e-03,1.54077032e-04,6.00915373e-05,9.94780958e-01,4.61396674e-04,1.24850849e-04,1.57076516e-04,2.51870696e-03,5.41483401e-04],[1.08785178e-04,1.11720459e-04,8.68999283e-04,4.49086772e-04,5.94627869e-04,9.97015119e-01,1.98079186e-04,5.78091945e-04,3.25235451e-05,4.30815235e-05],[1.05642866e-04,6.29661736e-05,1.41071971e-03,1.02912018e-03,2.62058838e-05,5.63393405e-04,9.93313968e-01,3.47314955e-04,1.24939403e-03,1.89123210e-03],[9.51970555e-03,4.81471332e-04,2.59190658e-03,2.75892951e-03,9.82683967e-04,9.51780297e-04,9.37505160e-04,9.65795159e-01,1.48322703e-02,1.14860001e-03],[8.23614560e-03,1.20204221e-02,4.66836570e-03,6.10145275e-03,6.00904133e-03,2.90664611e-03,2.94354018e-02,2.07864470e-03,9.18669999e-01,9.87390988e-03],[5.47478208e-03,6.23374712e-03,2.67653866e-03,3.93047289e-04,2.31260471e-02,2.08680751e-04,2.30260212e-02,3.08847558e-02,1.05773574e-02,8.97399008e-01]]
# tn=[[0.67169893,0.02034999,0.06576543,0.01246645,0.02392983,0.0234312,0.01266221,0.05118399,0.05250693,0.06600496],[0.08707482,0.40266889,0.12252203,0.12197114,0.10039062,0.02084504,0.01137811,0.01087478,0.0640249,0.05824969],[0.05614671,0.00565995,0.86008603,0.02196062,0.00973512,0.00679195,0.00928233,0.00747114,0.01403668,0.00882953],[0.02891685,0.03438186,0.02826797,0.71018712,0.03263769,0.05545752,0.03485012,0.01776934,0.02895553,0.02857603],[0.0271542,0.02042687,0.03289929,0.03449995,0.76403686,0.03659988,0.01546689,0.02301589,0.0276737,0.01822638],[0.01706785,0.00529305,0.02209745,0.04608181,0.00984829,0.85514909,0.01785264,0.01497697,0.00609248,0.00554046],[0.01774759,0.0105074,0.0167576,0.04735576,0.01375646,0.01222101,0.80186934,0.01654988,0.03096814,0.03226679],[0.04947947,0.0098463,0.03366041,0.04386688,0.01785084,0.04144608,0.01687652,0.67905921,0.08032149,0.02759281],[0.0582025,0.05141972,0.03956343,0.0363021,0.0298826,0.01895171,0.06382936,0.01468994,0.64837654,0.0387821,],[0.0790151,0.08347928,0.01531078,0.00888763,0.07706268,0.00819748,0.05770652,0.08057838,0.0689457,0.52081643]]

# print(l1_error_calculator(tb,t))
# print(l1_error_calculator(t,tn))