# Dependencies

We recommend creating a conda environment. 
```
conda create -n jax_deramerv3 --clone base
```

We refer to the [DreamerV3](https://github.com/danijar/dreamerv3) repository for the list of dependencies associated with the DreamerV3 based agents.
```
conda activate jax_deramerv3
pip install //DreamerV3 dependencies
```

Alternatively use our requirements files, although we stress that the specific [JAX](https://github.com/google/jax#pip-installation-gpu-cuda) installation required is hardware depedent.

```
conda activate jax_deramerv3
pip install -r requirements_jax.txt
```

# Running Experiments
For DreamerV3 based agents, navigate to the relevant subdirectory and run ```train.py```. The following command with run DreamerV3 on seaquest with the ```medium``` model size, property_1 for 20M frames.
```
cd dreamerV3-shield
python train.py --logdir ./logdir/seaquest/safe_prod_shield_prop_1_seed_7 --configs seaquest medium --shielding_type safe_prod --env.seaquest.property_file property_1 --normalise_ret False --run.steps 5000000 --seed 7
```
*Random seed can be set with the ```--seed``` flag (default 0).*

# Plotting

For plotting runs we use tensorboard. Navigate to the relevant subdirectory and start tensorboard.
```
cd dreamerV3-shield
tensorboard --logdir ./logdir/seaquest
```

# Acks

We refer to the following repositories from which our code is developed:

- [AMBS](https://github.com/sacktock/AMBS)
- [DreamerV3](https://github.com/danijar/dreamerv3)
- [Bounded Prescience](https://github.com/HjalmarWijk/bounded-prescience) (safety labels for Atari games)


