
import sys
sys.path.append('../../')

from model_checking import dfa
from model_checking import pctl

automaton = dfa.DFA([0,1,2,3], 0, [3])
automaton.add_edge(0, 1, dfa.Atom('bomb'))
automaton.add_edge(1, 2, dfa.Atom('bomb'))
automaton.add_edge(1, 3, dfa.Neg(dfa.Atom('bomb')))
automaton.add_edge(2, 0, dfa.Neg(dfa.Atom('bomb')))
automaton.add_edge(3, 0, dfa.Truth())
cost_function = dfa.Cost_Function(automaton)

def pctl_property(prob=0.9):
    return pctl.Implies(
        pctl.And(
            pctl.Neg(pctl.Atom("bomb")),
            pctl.Next(prob, pctl.Atom("bomb"))
        ),
        pctl.Next(prob, pctl.Atom("bomb"))
    )

def product_pctl_property(prob=0.9):
    return pctl.Always(prob, 5, pctl.Neg(pctl.Atom('accepting')))
