
import sys
sys.path.append('../../')

from model_checking import dfa
from model_checking import pctl

automaton = dfa.DFA([0,1,2,3,4,5], 0, [5])
automaton.add_edge(0, 1, dfa.Atom('colour'))

automaton.add_edge(1, 2, dfa.Atom('colour'))
automaton.add_edge(1, 5, dfa.Neg(dfa.Atom('colour')))

automaton.add_edge(2, 3, dfa.Atom('colour'))
automaton.add_edge(2, 5, dfa.Neg(dfa.Atom('colour')))

automaton.add_edge(3, 4, dfa.Atom('colour'))
automaton.add_edge(3, 5, dfa.Neg(dfa.Atom('colour')))

automaton.add_edge(4, 0, dfa.Neg(dfa.Atom('colour')))

automaton.add_edge(5, 0, dfa.Neg(dfa.Atom('colour')))
automaton.add_edge(5, 1, dfa.Atom('colour'))

cost_function = dfa.Cost_Function(automaton)

def pctl_property(prob=0.9):
    return pctl.Implies(
        pctl.And(
            pctl.Neg(pctl.Atom("colour")),
            pctl.Next(prob, pctl.Atom("colour"))
        ),
        pctl.Always(prob, 3, pctl.Atom("colour"))
    )

def product_pctl_property(prob=0.9):
    return pctl.Always(prob, 5, pctl.Neg(pctl.Atom('accepting')))
