
import sys
sys.path.append('../../')

from model_checking import dfa
from model_checking import pctl

automaton = dfa.DFA([i for i in range(22)], 0, [21])
automaton.add_edge(0, 1, dfa.Atom('bomb'))

automaton.add_edge(1, 2, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(1, 11, dfa.Atom('medic'))

automaton.add_edge(2, 3, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(2, 12, dfa.Atom('medic'))

automaton.add_edge(3, 4, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(3, 13, dfa.Atom('medic'))

automaton.add_edge(4, 5, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(4, 14, dfa.Atom('medic'))

automaton.add_edge(5, 6, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(5, 15, dfa.Atom('medic'))

automaton.add_edge(6, 7, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(6, 16, dfa.Atom('medic'))

automaton.add_edge(7, 8, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(7, 17, dfa.Atom('medic'))

automaton.add_edge(8, 9, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(8, 18, dfa.Atom('medic'))

automaton.add_edge(9, 10, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(9, 19, dfa.Atom('medic'))

automaton.add_edge(10, 21, dfa.Neg(dfa.Atom('medic')))
automaton.add_edge(10, 20, dfa.Atom('medic'))

automaton.add_edge(11, 0, dfa.Atom('medic'))
automaton.add_edge(11, 3, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(12, 0, dfa.Atom('medic'))
automaton.add_edge(12, 4, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(13, 0, dfa.Atom('medic'))
automaton.add_edge(13, 5, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(14, 0, dfa.Atom('medic'))
automaton.add_edge(14, 6, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(15, 0, dfa.Atom('medic'))
automaton.add_edge(15, 7, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(16, 0, dfa.Atom('medic'))
automaton.add_edge(16, 8, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(17, 0, dfa.Atom('medic'))
automaton.add_edge(17, 9, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(18, 0, dfa.Atom('medic'))
automaton.add_edge(18, 10, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(19, 0, dfa.Atom('medic'))
automaton.add_edge(19, 21, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(20, 0, dfa.Atom('medic'))
automaton.add_edge(20, 21, dfa.Neg(dfa.Atom('medic')))

automaton.add_edge(21, 0, dfa.Truth())

cost_function = dfa.Cost_Function(automaton)

def pctl_property(prob=0.9):
    return pctl.Implies(
        pctl.Atom('bomb'),
        pctl.Eventually(prob, 10, pctl.Always(prob, 2, pctl.Atom('medic')))
    )

def product_pctl_property(prob=0.9):
    return pctl.Always(prob, 10, pctl.Neg(pctl.Atom('accepting')))
