from .base import Baseline

import os
import time


class RandomSearch(Baseline):
    def __init__(self, config_space, eval_func, iter_num=200, save_dir='./results', task_name='default'):
        super().__init__(config_space, eval_func, iter_num, save_dir, task_name)

        self.timestamp = time.time()
        self.save_path = os.path.join(self.save_dir, '%s_%s_%d_%s.pkl' % (task_name, 'rs', iter_num, self.timestamp))

    def sample(self):
        repeated_flag = True
        while repeated_flag:
            repeated_flag = False
            config = self.config_space.sample_configuration()
            for observation in self.observations:
                if config == observation[0]:
                    repeated_flag = True
                    break
        return config
