from math import sqrt
import numpy as np
import pandas as pd


def diversity(pred1, pred2):
    return np.mean(np.linalg.norm(pred1 - pred2, ord=2, axis=1)) / sqrt(2)


def calculate_ranking(score_dict, ascending=False):
    rank_dict = dict()
    for key in score_dict:
        value_list = pd.Series(list(score_dict[key]))
        rank_array = np.array(value_list.rank(ascending=ascending))
        rank_dict[key] = rank_array

    return rank_dict
