### Reproducing figures and results

To train the models needed, run scripts in `train_scripts/`

Branch points are in `config/`, and can be recomputed using `notebooks/*_branch_points.ipynb`

All pre-processing of scRNA-seq dataset is done by `notebooks/scrna_covid_flu_dataset_preparation.ipynb`

All figures and results can then be generated with the notebooks in `notebooks/figures/`

### Description of files and directories

```
├── Makefile    <- Installation of dependencies
├── notebooks    <- Jupyter notebooks that explore data, plot results, and analyze results
│   └── figures    <- Jupyter notebooks that create figures
├── train_scripts   <- Scripts to launch training of models
├── config    <- Config files including branch points
├── README.md    <- This file
└── src    <- Source code
    ├── feature    <- Code for data loading and featurization
    ├── model    <- Code for model architectures and training
    ├── analysis    <- Code for analyzing results
    └── plot    <- Code for plotting and visualization
```
