
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# raw data
# data for literacy rates over time
literacy_data = np.array(
    [
        np.linspace(2000, 2020, 17),  # years
        np.random.rand(17) * 20 + 70,  # literacy rates (%)
        np.random.rand(17) * 40 + 30,  # internet penetration (%)
    ]
)

# data for internet access over time
internet_access_data = np.array(
    [
        np.linspace(2000, 2020, 17),  # years
        np.random.rand(17) * 20 + 50,  # literacy rates (%)
        np.random.rand(17) * 40 + 50,  # internet penetration (%)
    ]
)
xlabel = "Years"
ylabel = "Literacy Rates (%)"
zlabel = "Internet Penetration (%)"
labels = ["Literacy Trends", "Internet Access Trends"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# data preparation
x_literacy = literacy_data[0]
y_literacy = literacy_data[1]
z_literacy = literacy_data[2]

x_internet = internet_access_data[0]
y_internet = internet_access_data[1]
z_internet = internet_access_data[2]

fig, ax = plt.subplots(figsize=(10, 8), subplot_kw={"projection": "3d"})

radius_x = 2020
radius_y = 100
radius_z = 100
ax.set_xlim3d([2000, radius_x])
ax.set_ylim3d([50, radius_y])
ax.set_zlim3d([30, radius_z])
ax.view_init(elev=20.0, azim=60)
ax.dist = 8

# 3D scatter
ax.scatter3D(x_literacy, y_literacy, z_literacy, color="forestgreen", label=labels[0], marker='o')

# draw the path
# hypothetical literacy trend trajectory
ax.plot(x_literacy[0:4], y_literacy[0:4], z_literacy[0:4], ls="-", color="green")
ax.plot(x_literacy[4:8], y_literacy[4:8], z_literacy[4:8], ls="-", color="chartreuse")
ax.plot(x_literacy[8:12], y_literacy[8:12], z_literacy[8:12], ls="-", color="lime")
ax.plot(x_literacy[12:], y_literacy[12:], z_literacy[12:], ls="-", color="lawngreen")

# second dataset: internet access trends
ax.scatter3D(x_internet, y_internet, z_internet, color="royalblue", label=labels[1], marker='^')

# hypothetical internet access trend trajectories
ax.plot(x_internet[0:4], y_internet[0:4], z_internet[0:4], ls="-", color="blue")
ax.plot(x_internet[4:8], y_internet[4:8], z_internet[4:8], ls="-", color="dodgerblue")
ax.plot(x_internet[8:12], y_internet[8:12], z_internet[8:12], ls="-", color="deepskyblue")
ax.plot(x_internet[12:], y_internet[12:], z_internet[12:], ls="-", color="skyblue")

# labels and grid
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.grid(True)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_22.pdf", bbox_inches="tight")
