
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)

# Age (years) values, ranging from 20 to 70
age = np.array(
    [
        [20, 30, 40, 50, 60, 70],
        [20, 30, 40, 50, 60, 70],
        [20, 30, 40, 50, 60, 70],
        [20, 30, 40, 50, 60, 70],
        [20, 30, 40, 50, 60, 70],
        [20, 30, 40, 50, 60, 70],
    ]
)

# Physical Activity (hours per week) values, ranging from 0 to 10
physical_activity = np.array(
    [
        [0, 0, 0, 0, 0, 0],
        [2, 2, 2, 2, 2, 2],
        [4, 4, 4, 4, 4, 4],
        [6, 6, 6, 6, 6, 6],
        [8, 8, 8, 8, 8, 8],
        [10, 10, 10, 10, 10, 10],
    ]
)

# Heart Health Score values, simulated with plausible trends
heart_health_score = np.array(
    [
        [80, 78, 75, 70, 65, 60],
        [85, 82, 78, 73, 68, 63],
        [90, 88, 85, 80, 75, 70],
        [95, 93, 90, 85, 80, 75],
        [100, 98, 95, 90, 85, 80],
        [105, 102, 100, 95, 90, 85],
    ]
)

xlabel = "Age (years)"
ylabel = "Physical Activity (hours per week)"
zlabel = "Heart Health Score (out of 100)"
title = "Heart Health Score Variation\nwith Age and Physical Activity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig = plt.figure(
    figsize=(10, 6)
)
ax = fig.add_subplot(111, projection="3d")

# Plot a 3D surface
surf = ax.plot_surface(age, physical_activity, heart_health_score, cmap="viridis", edgecolor="black")

# Labels and title
ax.set_xlabel(xlabel,fontsize=8)
ax.set_ylabel(ylabel,fontsize=8)
ax.set_zlabel(zlabel,fontsize=8)
ax.set_title(title, y=1.00)
ax.set_box_aspect(aspect=(1.5, 1, 1))  # Aspect ratio for better visualization

# Add a color bar to show color scale
cbar = fig.colorbar(surf, ax=ax, shrink=0.5, aspect=5)
cbar.set_label(zlabel)

# ===================
# Part 4: Saving Output
# ===================
# Saving the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_29.pdf", bbox_inches="tight")
