

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define a new dataset representing population growth trends
x = np.linspace(0, 20, 200)  # Years
y = np.linspace(1, 50, 200)  # Locations
x, y = np.meshgrid(x, y)

z1 = 100 + 10 * x  # Linear growth
z2 = 100 + 50 * np.sin(y / 5) * np.cos(x / 2)  # Seasonal fluctuations
z3 = 100 * np.exp(x / 10)  # Exponential growth
z4 = 100 * np.log(x + 1)  # Logarithmic growth

titles = ["Linear Growth", "Seasonal Fluctuations", "Exponential Growth", "Logarithmic Growth"]
xlabels = ["Year", "Year", "Year", "Year"]
ylabels = ["Location", "Location", "Location", "Location"]
zlabels = ["Population (in thousands)", "Population (in thousands)", "Population (in thousands)", "Population (in thousands)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specified size to match the original image's dimensions
fig = plt.figure(figsize=(15, 10))

# Plot the first subplot
ax1 = fig.add_subplot(
    141, projection="3d", facecolor="white"
)
surf1 = ax1.plot_surface(x, y, z1, cmap="plasma")
ax1.set_title(titles[0], fontsize=12, y=-0.1)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.set_zlabel(zlabels[0], fontsize=12)

# Plot the second subplot
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(x, y, z2, cmap="plasma")
ax2.set_title(titles[1], fontsize=14, y=-0.1)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.set_zlabel(zlabels[1], fontsize=12, y=-0.3, rotation=0)

# Plot the third subplot
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(x, y, z3, cmap="plasma")
ax3.set_title(titles[2], fontsize=14, y=-0.1)
ax3.set_xlabel(xlabels[2], fontsize=12)
ax3.set_ylabel(ylabels[2], fontsize=12)
ax3.set_zlabel(zlabels[2], fontsize=12, rotation=90)

# Plot the fourth subplot
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(x, y, z4, cmap="plasma")
ax4.set_title(titles[3], fontsize=14, y=-0.1)
ax4.set_xlabel(xlabels[3], fontsize=12)
ax4.set_ylabel(ylabels[3], fontsize=12)
ax4.set_zlabel(zlabels[3], fontsize=12, rotation=90, x=-100)

# Zoom all the subplots
ax1.set_box_aspect(aspect=None)
ax2.set_box_aspect(aspect=None)
ax3.set_box_aspect(aspect=None)
ax4.set_box_aspect(aspect=None)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and spacing
plt.tight_layout()

# Show the plot
plt.savefig("3d_30.pdf", bbox_inches="tight")

