

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new data representing weather conditions over a week
np.random.seed(42)
time = np.linspace(0, 7, 17)  # Time over a week (0 to 7 days)
temperature = np.random.normal(loc=20, scale=5, size=17)  # Temperature in °C
humidity = np.random.normal(loc=60, scale=10, size=17)  # Humidity in %
pressure = np.random.normal(loc=1013, scale=10, size=17)  # Pressure in hPa

# Text labels and settings
xlabel = "Time (days)"
ylabel = "Temperature (°C)"
zlabel = "Humidity (%)"
chart_title = "Weekly Weather Data"
legend_label = "Weather Data Points"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(7, 7), subplot_kw={"projection": "3d"})

radius = 7
ax.set_xlim3d([0, radius])
ax.set_ylim3d([temperature.min() - 10, temperature.max() + 10])
ax.set_zlim3d([humidity.min() - 10, humidity.max() + 10])
ax.view_init(elev=20.0, azim=60)
ax.dist = 8

color_points = "mediumseagreen"  # Color for scatter points
color_lines = "slateblue"  # Color for connecting lines

# 3D scatter with optimized color scheme and styles
ax.scatter3D(time, temperature, humidity, color=color_points, marker="o", s=50, label=legend_label)

# Draw connections with updated styles
# Example connections (can be adapted based on data characteristics)
# Set 1
ax.plot(time[:4], temperature[:4], humidity[:4], ls="--", color=color_lines, lw=1.5)
# Set 2
ax.plot(np.hstack((time[4], time[5:8])), np.hstack((temperature[4], temperature[5:8])), np.hstack((humidity[4], humidity[5:8])), ls="--", color=color_lines, lw=1.5)
# Set 3
ax.plot(np.hstack((time[8], time[9:12])), np.hstack((temperature[8], temperature[9:12])), np.hstack((humidity[8], humidity[9:12])), ls="--", color=color_lines, lw=1.5)
# Set 4
ax.plot(np.hstack((time[12], time[13:15])), np.hstack((temperature[12], temperature[13:15])), np.hstack((humidity[12], humidity[13:15])), ls="--", color=color_lines, lw=1.5)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(chart_title, pad=20)

plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_35.pdf", bbox_inches="tight")
