
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
X = np.arange(0, 100, 1)  # Days
Y = np.arange(1, 11, 1)  # Stock indices 1 to 10
X, Y = np.meshgrid(X, Y)

# Simulated stock prices with sinusoidal patterns and noise
Z = np.sin(X * 0.1) * Y + np.random.normal(0, 0.5, X.shape)

# Axes Limits and Labels
xlabel_value = "Days"
ylabel_value = "Stock Index"
zlabel_value = "Stock Price (in $)"
title_value = "Stock Market Trends"

zlim_values = [-5, 15]  # Setting a plausible range for stock prices

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8), subplot_kw={"projection": "3d"})
cmap_custom = cm.get_cmap("terrain")

# Plot the surface
surf = ax.plot_surface(X, Y, Z, cmap=cmap_custom, linewidth=1, edgecolor='k', antialiased=True)

# Customize the z axis
ax.set_zlim(zlim_values)
ax.zaxis.set_major_formatter("{x:.02f}")

# Labeling axes and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_zlabel(zlabel_value)
ax.set_title(title_value)

# Add a color bar which maps values to colors
fig.colorbar(surf, shrink=0.5, aspect=10)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_36.pdf", bbox_inches="tight")
