

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm

# ===================
# Part 2: Data Preparation
# ===================
# Generating data for health domain.
import numpy as np

np.random.seed(1)
age = np.arange(20, 80, 10)
days = np.arange(1, 366, 1)
days, age = np.meshgrid(days, age)
heart_rate = 70 + 10 * np.sin(np.deg2rad(days)) + (age - 50) * 0.5

# Axes Limits and Labels
xlabel_value = "Day of the Year"
ylabel_value = "Age Group"
zlabel_value = "Average Daily Heart Rate (bpm)"
title_value = "Simulated Average Daily Heart Rate by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6), subplot_kw={"projection": "3d"})

zlim_values = [50, 100]

# Plot the surface.
surf = ax.plot_surface(days, age, heart_rate, cmap=cm.Spectral, edgecolor='none')

# Customize the z axis.
ax.set_zlim(zlim_values)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_zlabel(zlabel_value)
ax.set_title(title_value)

# Add a color bar which maps values to colors.
fig.colorbar(surf, shrink=0.5, aspect=10, label='Heart Rate (bpm)')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_37.pdf", bbox_inches="tight")

