

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm


# ===================
# Part 2: Data Preparation
# ===================
# Data for crop yield surface.
import numpy as np
np.random.seed(0)
X = np.arange(0, 10, 0.1)
Y = np.arange(0, 10, 0.1)
X, Y = np.meshgrid(X, Y)
Z = np.sin(X) * np.exp(-Y/5) + np.cos(Y)

# Axes Limits and Labels
xlabel_value = "Soil Quality"
ylabel_value = "Rainfall (mm)"
title_value = "Simulated Crop Yield"
supertitle_value = "Agricultural Crop Yield Over Various Conditions"
zlabel_value = "Crop Yield (tons/ha)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8), subplot_kw={"projection": "3d"})

# Color and style adjustments
zlim_values = [-1.5, 1.5]
colormap = cm.terrain

# Plot the surface.
surf = ax.plot_surface(X, Y, Z, cmap=colormap, edgecolor='none')

# Customize the z axis.
ax.set_zlim(zlim_values)

# A StrMethodFormatter is used automatically
ax.zaxis.set_major_formatter("{x:.02f}")
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_zlabel(zlabel_value)

# Add a color bar which maps values to colors.
fig.colorbar(surf, shrink=0.5, aspect=10)

# Add title and supertitle
plt.suptitle(supertitle_value, fontsize=16)
plt.title(title_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_38.pdf", bbox_inches="tight")

