
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Fixing random state for reproducibility
np.random.seed(0)
# New dataset representing average vehicles (in thousands) passing through checkpoints
hist = np.array(
    [
        [50.0, 45.0, 60.0, 55.0],
        [40.0, 50.0, 70.0, 65.0],
        [30.0, 35.0, 75.0, 60.0],
        [45.0, 55.0, 65.0, 70.0],
    ]
)
xedges = np.array([0.0, 1.25, 2.5, 3.75, 5.0])
yedges = np.array([0.0, 1.25, 2.5, 3.75, 5.0])

# Label parameters
xlabel = "Checkpoint Longitude"
ylabel = "Checkpoint Latitude"
zlabel = "Vehicles (thousands)"
title = "Average Number of Vehicles by Checkpoint"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Construct arrays for the anchor positions of the 16 bars.
xpos, ypos = np.meshgrid(xedges[:-1] + 0.25, yedges[:-1] + 0.25, indexing="ij")
xpos = xpos.ravel()
ypos = ypos.ravel()
zpos = 0

# Construct arrays with the dimensions for the 16 bars.
dx = dy = 0.5 * np.ones_like(zpos)
dz = hist.ravel()

fig = plt.figure(figsize=(10, 10))
ax = fig.add_subplot(projection="3d")

# Create a colormap for the color bar
colors = plt.cm.terrain(dz / dz.max())
bar3d = ax.bar3d(xpos, ypos, zpos, dx, dy, dz, zsort="average", color=colors)

# Add color bar which maps values to colors.
sm = plt.cm.ScalarMappable(cmap=plt.cm.terrain, norm=plt.Normalize(vmin=dz.min(), vmax=dz.max()))
sm.set_array([])
cbar = fig.colorbar(sm, ax=ax, shrink=0.5, aspect=10)  # Adjust colorbar position and size
cbar.set_label(zlabel)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_40.pdf", bbox_inches="tight")
