
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data: Age, Number of Movies, Box Office Earnings (in Millions USD)
new_actors = np.array(
    [
        [22, 23, 24, 25, 26, 27, 28, 29, 30, 31],
        [1, 2, 1, 3, 2, 4, 3, 5, 2, 3],
        [10, 15, 12, 18, 20, 25, 22, 30, 28, 26],
    ]
)
established_actors = np.array(
    [
        [32, 35, 34, 36, 38, 40, 37, 39, 41, 42],
        [10, 15, 12, 14, 18, 20, 13, 17, 22, 19],
        [50, 60, 55, 70, 80, 85, 65, 75, 90, 95],
    ]
)
veteran_actors = np.array(
    [
        [45, 48, 50, 52, 55, 57, 49, 53, 54, 56],
        [25, 30, 28, 35, 38, 40, 32, 36, 42, 39],
        [120, 135, 125, 140, 150, 165, 130, 155, 160, 170],
    ]
)
xlabel = "Age"
ylabel = "Number of Movies"
zlabel = "Box Office Earnings (in Millions USD)"
title = "Entertainment Industry Insights: Age vs. Movies vs. Earnings"
legend_labels = ["New Actors", "Established Actors", "Veteran Actors"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(111, projection='3d')

# Scatter plots with optimized elements
ax.scatter(new_actors[0], new_actors[1], new_actors[2], marker="o", color="teal", s=50, label=legend_labels[0])
ax.scatter(established_actors[0], established_actors[1], established_actors[2], marker="^", color="magenta", s=50, label=legend_labels[1])
ax.scatter(veteran_actors[0], veteran_actors[1], veteran_actors[2], marker="s", color="olive", s=50, label=legend_labels[2])

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# Adjust ticks
ax.set_xticks([20, 25, 30, 35, 40, 45, 50, 55, 60])
ax.set_yticks([0, 5, 10, 15, 20, 25, 30, 35, 40, 45])
ax.set_zticks([0, 20, 40, 60, 80, 100, 120, 140, 160, 180, 200])

# Aspect ratio
ax.set_box_aspect([1, 1, 1])  # For a better visualization

# Adding Legend
ax.legend(loc='upper left')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_42.pdf", bbox_inches="tight")
