

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
model_1 = np.array(
    [
        np.random.uniform(15, 25, 10),  # Efficiency (%)
        np.random.uniform(1, 5, 10),    # Power Output (kW)
        np.random.uniform(500, 1500, 10), # Cost ($)
    ]
)
model_2 = np.array(
    [
        np.random.uniform(16, 26, 10),  # Efficiency (%)
        np.random.uniform(2, 6, 10),    # Power Output (kW)
        np.random.uniform(600, 1600, 10), # Cost ($)
    ]
)
model_3 = np.array(
    [
        np.random.uniform(17, 27, 10),  # Efficiency (%)
        np.random.uniform(3, 7, 10),    # Power Output (kW)
        np.random.uniform(700, 1700, 10), # Cost ($)
    ]
)
xlabel = "Efficiency (%)"
ylabel = "Power Output (kW)"
zlabel = "Cost ($)"
title = "Solar Panel Metrics"
legend_labels = ["Model 1", "Model 2", "Model 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

ax.scatter(model_1[0], model_1[1], model_1[2], marker="o", color="steelblue", depthshade=False, label=legend_labels[0])
ax.scatter(model_2[0], model_2[1], model_2[2], marker="^", color="forestgreen", depthshade=False, label=legend_labels[1])
ax.scatter(model_3[0], model_3[1], model_3[2], marker="s", color="darkorange", depthshade=False, label=legend_labels[2])

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

ax.set_xticks(np.arange(15, 30, 2))
ax.set_yticks(np.arange(1, 8, 1))
ax.set_zticks(np.arange(500, 1800, 200))

ax.legend()

# Adjust the aspect ratio and appearance
ax.set_box_aspect([1, 1, 1])  # aspect ratio is 1:1:1.5
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("3d_43.pdf", bbox_inches="tight")

