
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
years = np.array([2000, 2005, 2010, 2015, 2020])
gdp_country1 = np.array([1.2, 1.5, 1.8, 2.4, 3.2])
gdp_country2 = np.array([0.8, 1.0, 1.4, 1.9, 2.6])
gdp_country3 = np.array([0.5, 0.8, 1.2, 1.5, 2.1])

source1 = np.array([years, gdp_country1, np.random.normal(7, 1, len(years))])
source2 = np.array([years, gdp_country2, np.random.normal(6, 1, len(years))])
source3 = np.array([years, gdp_country3, np.random.normal(5, 1, len(years))])

xlabel = "Year"
ylabel = "GDP (in Trillions USD)"
zlabel = "Economic Indicator (Index)"
chart_title = "Economic Growth Over Time"
legend_labels = ["Country 1", "Country 2", "Country 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

ax.plot(source1[0], source1[1], source1[2], color="purple", linestyle='--', marker='o', label=legend_labels[0])
ax.plot(source2[0], source2[1], source2[2], color="green", linestyle='-.', marker='s', label=legend_labels[1])
ax.plot(source3[0], source3[1], source3[2], color="teal", linestyle=':', marker='^', label=legend_labels[2])

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(chart_title)
ax.legend()

ax.set_xticks(np.arange(2000, 2025, 5))
ax.set_yticks(np.arange(0, 4, 0.5))
ax.set_zticks(np.arange(4, 9, 1))

ax.grid(True)
ax.set_box_aspect(aspect=[2, 2, 2])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_45.pdf", bbox_inches="tight")
