
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Representing influence over centuries
centuries = np.arange(16, 22)  # 16th to 21st century
influence_a = np.random.randint(1, 10, size=6)
influence_b = np.random.randint(1, 15, size=6)
influence_c = np.random.randint(1, 20, size=6)

philosopher1 = np.array([centuries, influence_a, np.random.randint(1, 7, size=6)])
philosopher2 = np.array([centuries, influence_b, np.random.randint(1, 10, size=6)])
philosopher3 = np.array([centuries, influence_c, np.random.randint(1, 12, size=6)])

xlabel = "Centuries"
ylabel = "Influence Score"
zlabel = "Influence Metric"
title = "Influence of Philosophers Over Centuries"
legendlabels = ["Philosopher A", "Philosopher B", "Philosopher C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

# Use different style and colors for lines.
ax.plot(philosopher1[0], philosopher1[1], philosopher1[2], color="teal", linestyle="-", marker='o', linewidth=2, label=legendlabels[0])
ax.plot(philosopher2[0], philosopher2[1], philosopher2[2], color="goldenrod", linestyle="--", marker='s', linewidth=2, label=legendlabels[1])
ax.plot(philosopher3[0], philosopher3[1], philosopher3[2], color="coral", linestyle=":", marker='^', linewidth=2, label=legendlabels[2])

ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15, pad=20)

ax.set_xticks([16, 17, 18, 19, 20, 21])
ax.set_yticks(np.arange(0, 20, 2))
ax.set_zticks(np.arange(0, 15, 2))

ax.legend(loc='upper left')

# Set the aspect and zoom level
ax.set_box_aspect(aspect=None, zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_46.pdf", bbox_inches="tight")
