
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(48)
# Fixing random state for reproducibility

# Define custom histogram data for communication tools usage across different professions
hist = np.array([[12, 5, 3, 8], [7, 10, 2, 9], [6, 4, 14, 5], [3, 9, 8, 11]])

# Define the edges of the bins
xedges = np.array([0, 1, 2, 3, 4])
yedges = np.array([0, 1, 2, 3, 4])

# Construct arrays for the anchor positions of the bars.
xpos, ypos = np.meshgrid(xedges[:-1] + 0.25, yedges[:-1] + 0.25, indexing="ij")
xpos = xpos.ravel()
ypos = ypos.ravel()
zpos = 0

# Only keep positions where there is a non-zero bar
non_zero_indices = hist.ravel() > 0
xpos = xpos[non_zero_indices]
ypos = ypos[non_zero_indices]
dz = hist.ravel()[non_zero_indices]

# All bars have the same width and depth
dx = dy = 0.5 * np.ones_like(dz)

# Axes Limits and Labels
ax_xlabel = "Communication Tool"
ax_ylabel = "Profession"
ax_zlabel = "Usage Count"

# Labels for the axes
xtick_labels = ["Email", "Phone Calls", "Video Conf.", "Instant Msg."]
ytick_labels = ["Engineering", "Marketing", "Sales", "HR"]

# Chart title
chart_title = "Usage of Communication Tools across Professions"

# Legend labels
legend_labels = ["Engineering", "Marketing", "Sales", "HR"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a new figure for the modified 3D bar plot
fig = plt.figure(figsize=(10, 9))
ax = fig.add_subplot(projection="3d")

# Color palette for bars
bar_colors = ["#FF5733", "#33FF57", "#3357FF", "#FF33A6"]

# Set different colors for the bars
colors = np.array([bar_colors[int(i)] for i in ypos])

# Plotting the bars with custom colors
ax.bar3d(xpos, ypos, zpos, dx, dy, dz, zsort="average", color=colors)

# Set the labels and title
ax.set_xlabel(ax_xlabel,labelpad=10)
ax.set_ylabel(ax_ylabel,labelpad=10)
ax.set_zlabel(ax_zlabel,labelpad=10)
ax.set_title(chart_title)

# Set custom tick labels
ax.set_xticks(np.arange(len(xtick_labels)))
ax.set_xticklabels(xtick_labels)
ax.set_yticks(np.arange(len(ytick_labels)))
ax.set_yticklabels(ytick_labels)

# Add a legend with custom labels
custom_legend = [plt.Line2D([0], [0], color=bar_colors[i], lw=4) for i in range(len(bar_colors))]
ax.legend(custom_legend, legend_labels, loc="upper right")

# Adjust the aspect ratio
ax.set_box_aspect(aspect=None, zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to minimize white space
plt.tight_layout()
plt.savefig("3d_48.pdf", bbox_inches="tight")
